"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSecurityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_started = require("./components/get_started");
var _side_navigation = require("./components/side_navigation");
var _upselling = require("./components/upselling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessSecurityPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
  }
  setup(_core, setupDeps) {
    (0, _upselling.registerUpsellings)(setupDeps.securitySolution.upselling, this.config.productTypes);
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution,
      serverless
    } = startDeps;
    securitySolution.setIsSidebarEnabled(false);
    securitySolution.setGetStartedPage((0, _get_started.getSecurityGetStartedComponent)(core, startDeps));
    serverless.setProjectHome('/app/security');
    serverless.setSideNavComponent((0, _side_navigation.getSecuritySideNavComponent)(core, startDeps));
    return {};
  }
  stop() {}
}
exports.ServerlessSecurityPlugin = ServerlessSecurityPlugin;