"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavLinks = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavLinks = () => {
  const {
    securitySolution
  } = (0, _services.useKibana)().services;
  const {
    getNavLinks$
  } = securitySolution;
  const navLinks$ = (0, _react.useMemo)(() => getNavLinks$(), [getNavLinks$]);
  return (0, _useObservable.default)(navLinks$, []);
};
exports.useNavLinks = useNavLinks;