"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinkProps = exports.useGetLinkProps = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _react = require("react");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLinkProps = props => {
  const {
    application
  } = (0, _services.useKibana)().services;
  return (0, _react.useMemo)(() => getLinkProps({
    ...props,
    application
  }), [application, props]);
};
exports.useLinkProps = useLinkProps;
const useGetLinkProps = () => {
  const {
    application
  } = (0, _services.useKibana)().services;
  return (0, _react.useCallback)(props => getLinkProps({
    ...props,
    application
  }), [application]);
};
exports.useGetLinkProps = useGetLinkProps;
const getLinkProps = ({
  deepLinkId,
  path,
  onClick: onClickProps,
  appId = _common.APP_UI_ID,
  application
}) => {
  const {
    getUrlForApp,
    navigateToUrl
  } = application;
  const url = getUrlForApp(appId, {
    deepLinkId,
    path
  });
  return {
    href: url,
    onClick: ev => {
      if (isModifiedEvent(ev)) {
        return;
      }
      ev.preventDefault();
      navigateToUrl(url);
      if (onClickProps) {
        onClickProps(ev);
      }
    }
  };
};
const isModifiedEvent = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;