"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.registerUpsellings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/security-solution-plugin/common");
var _pli_features = require("../../../common/pli/pli_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const GenericUpsellingPageLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/generic_upselling_page'))));
const GenericUpsellingSectionLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/generic_upselling_section'))));
const registerUpsellings = (upselling, productTypes) => {
  const enabledPLIsSet = new Set((0, _pli_features.getProductAppFeatures)(productTypes));
  const upsellingPagesToRegister = upsellingPages.reduce((pageUpsellings, {
    pageName,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      pageUpsellings[pageName] = component;
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      sectionUpsellings[id] = component;
    }
    return sectionUpsellings;
  }, {});
  upselling.registerPages(upsellingPagesToRegister);
  upselling.registerSections(upsellingSectionsToRegister);
};

// Upsellings for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = [{
  pageName: _common.SecurityPageName.entityAnalytics,
  pli: _common.AppFeatureKey.advancedInsights,
  component: () => /*#__PURE__*/_react.default.createElement(GenericUpsellingPageLazy, {
    requiredPLI: _common.AppFeatureKey.advancedInsights
  })
}];

// Upsellings for sections, linked by arbitrary ids
exports.upsellingPages = upsellingPages;
const upsellingSections = [{
  id: 'entity_analytics_panel',
  pli: _common.AppFeatureKey.advancedInsights,
  component: () => /*#__PURE__*/_react.default.createElement(GenericUpsellingSectionLazy, {
    requiredPLI: _common.AppFeatureKey.advancedInsights
  })
}];
exports.upsellingSections = upsellingSections;