"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProductTypeByPLI = void 0;
var _pli_config = require("../../../../common/pli/pli_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useProductTypeByPLI = requiredPLI => {
  if (_pli_config.PLI_APP_FEATURES.security.essentials.includes(requiredPLI)) {
    return 'Security Essentials';
  }
  if (_pli_config.PLI_APP_FEATURES.security.complete.includes(requiredPLI)) {
    return 'Security Complete';
  }
  if (_pli_config.PLI_APP_FEATURES.endpoint.essentials.includes(requiredPLI)) {
    return 'Endpoint Essentials';
  }
  if (_pli_config.PLI_APP_FEATURES.endpoint.complete.includes(requiredPLI)) {
    return 'Endpoint Complete';
  }
  if (_pli_config.PLI_APP_FEATURES.cloud.essentials.includes(requiredPLI)) {
    return 'Cloud Essentials';
  }
  if (_pli_config.PLI_APP_FEATURES.cloud.complete.includes(requiredPLI)) {
    return 'Cloud Complete';
  }
  return null;
};
exports.useProductTypeByPLI = useProductTypeByPLI;