"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.getFinishedStepsInitialStates = exports.getActiveSectionsInitialStates = exports.getActiveCardsInitialStates = void 0;
var _helpers = require("./helpers");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = (state, action) => {
  if (action.type === _types.GetStartedPageActions.ToggleProduct) {
    const activeProducts = new Set([...state.activeProducts]);
    if (activeProducts.has(action.payload.section)) {
      activeProducts.delete(action.payload.section);
    } else {
      activeProducts.add(action.payload.section);
    }
    return {
      ...state,
      activeProducts,
      activeCards: (0, _helpers.setupCards)(state.finishedSteps, activeProducts)
    };
  }
  if (action.type === _types.GetStartedPageActions.AddFinishedStep) {
    const finishedSteps = {
      ...state.finishedSteps,
      [action.payload.cardId]: state.finishedSteps[action.payload.cardId] ? new Set([...state.finishedSteps[action.payload.cardId]]) : new Set()
    };
    finishedSteps[action.payload.cardId].add(action.payload.stepId);
    return {
      ...state,
      finishedSteps,
      activeCards: (0, _helpers.updateCard)({
        finishedSteps,
        activeProducts: state.activeProducts,
        activeCards: state.activeCards,
        cardId: action.payload.cardId,
        sectionId: action.payload.sectionId
      })
    };
  }
  return state;
};
exports.reducer = reducer;
const getFinishedStepsInitialStates = ({
  finishedSteps
}) => {
  const initialStates = Object.entries(finishedSteps).reduce((acc, [cardId, stepIdsByCard]) => {
    if (stepIdsByCard) {
      acc[cardId] = new Set(stepIdsByCard);
    }
    return acc;
  }, {});
  return initialStates;
};
exports.getFinishedStepsInitialStates = getFinishedStepsInitialStates;
const getActiveSectionsInitialStates = ({
  activeProducts
}) => new Set(activeProducts);
exports.getActiveSectionsInitialStates = getActiveSectionsInitialStates;
const getActiveCardsInitialStates = ({
  activeProducts,
  finishedSteps
}) => (0, _helpers.setupCards)(finishedSteps, activeProducts);
exports.getActiveCardsInitialStates = getActiveCardsInitialStates;