"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateCard = exports.setupCards = exports.isCardActive = exports.getCardTimeInMinutes = exports.getCardStepsLeft = void 0;
var _sections = require("./sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCardTimeInMinutes = (card, stepsDone) => {
  var _card$steps$reduce, _card$steps;
  return (_card$steps$reduce = (_card$steps = card.steps) === null || _card$steps === void 0 ? void 0 : _card$steps.reduce((totalMin, {
    timeInMinutes,
    id: stepId
  }) => totalMin += stepsDone.has(stepId) ? 0 : timeInMinutes !== null && timeInMinutes !== void 0 ? timeInMinutes : 0, 0)) !== null && _card$steps$reduce !== void 0 ? _card$steps$reduce : 0;
};
exports.getCardTimeInMinutes = getCardTimeInMinutes;
const getCardStepsLeft = (card, stepsDone) => {
  var _card$steps$length, _card$steps2, _stepsDone$size;
  return ((_card$steps$length = (_card$steps2 = card.steps) === null || _card$steps2 === void 0 ? void 0 : _card$steps2.length) !== null && _card$steps$length !== void 0 ? _card$steps$length : 0) - ((_stepsDone$size = stepsDone.size) !== null && _stepsDone$size !== void 0 ? _stepsDone$size : 0);
};
exports.getCardStepsLeft = getCardStepsLeft;
const isCardActive = (card, activeProducts) => {
  var _card$productTypeRequ;
  return !card.productTypeRequired || ((_card$productTypeRequ = card.productTypeRequired) === null || _card$productTypeRequ === void 0 ? void 0 : _card$productTypeRequ.some(condition => activeProducts.has(condition)));
};
exports.isCardActive = isCardActive;
const setupCards = (finishedSteps, activeProducts) => activeProducts.size > 0 ? (0, _sections.getSections)().reduce((acc, section) => {
  var _section$cards;
  const cardsInSections = (_section$cards = section.cards) === null || _section$cards === void 0 ? void 0 : _section$cards.reduce((accCards, card) => {
    if (isCardActive(card, activeProducts)) {
      var _finishedSteps$card$i;
      const stepsDone = (_finishedSteps$card$i = finishedSteps[card.id]) !== null && _finishedSteps$card$i !== void 0 ? _finishedSteps$card$i : new Set();
      const timeInMins = getCardTimeInMinutes(card, stepsDone);
      const stepsLeft = getCardStepsLeft(card, stepsDone);
      accCards[card.id] = {
        id: card.id,
        timeInMins,
        stepsLeft
      };
    }
    return accCards;
  }, {});
  if (cardsInSections) {
    acc[section.id] = cardsInSections;
  }
  return acc;
}, {}) : null;
exports.setupCards = setupCards;
const updateCard = ({
  finishedSteps,
  activeProducts,
  activeCards,
  sectionId,
  cardId
}) => {
  const sections = (0, _sections.getSections)();
  const section = sections.find(({
    id
  }) => id === sectionId);
  const cards = section === null || section === void 0 ? void 0 : section.cards;
  const card = cards === null || cards === void 0 ? void 0 : cards.find(({
    id
  }) => id === cardId);
  if (!card || !activeCards) {
    return activeCards;
  }
  if (isCardActive(card, activeProducts)) {
    var _finishedSteps$cardId;
    const stepsDone = (_finishedSteps$cardId = finishedSteps[cardId]) !== null && _finishedSteps$cardId !== void 0 ? _finishedSteps$cardId : new Set();
    const timeInMins = getCardTimeInMinutes(card, stepsDone);
    const stepsLeft = getCardStepsLeft(card, stepsDone);
    return {
      ...activeCards,
      [sectionId]: {
        ...activeCards[sectionId],
        [cardId]: {
          id: cardId,
          timeInMins,
          stepsLeft
        }
      }
    };
  }
  return activeCards;
};
exports.updateCard = updateCard;