"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStartedComponent = exports.GetStarted = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = require("@emotion/react");
var _welcome_panel = require("./welcome_panel");
var _toggle_panel = require("./toggle_panel");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetStartedComponent = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    css: (0, _react2.css)`
          padding: 0 ${euiTheme.base * 2.25}px;
        `,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      css: (0, _react2.css)`
              padding-left: ${euiTheme.size.xs};
            `
    }, /*#__PURE__*/_react.default.createElement("span", null, _translations.GET_STARTED_PAGE_TITLE)),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
      className: "eui-displayBlock"
    }, _translations.GET_STARTED_PAGE_SUBTITLE), /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-displayBlock"
    }, _translations.GET_STARTED_PAGE_DESCRIPTION))
  }, /*#__PURE__*/_react.default.createElement(_welcome_panel.WelcomePanel, null)), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    bottomBorder: "extended",
    grow: true,
    restrictWidth: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_toggle_panel.TogglePanel, null)));
};
exports.GetStartedComponent = GetStartedComponent;
GetStartedComponent.displayName = 'GetStartedComponent';
const GetStarted = /*#__PURE__*/_react.default.memo(GetStartedComponent);
exports.GetStarted = GetStarted;