"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productTypes = exports.productType = exports.productTier = exports.productLine = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productLine = _configSchema.schema.oneOf([_configSchema.schema.literal('security'), _configSchema.schema.literal('endpoint'), _configSchema.schema.literal('cloud')]);
exports.productLine = productLine;
const productTier = _configSchema.schema.oneOf([_configSchema.schema.literal('essentials'), _configSchema.schema.literal('complete')]);
exports.productTier = productTier;
const productType = _configSchema.schema.object({
  product_line: productLine,
  product_tier: productTier
});
exports.productType = productType;
const productTypes = _configSchema.schema.arrayOf(productType, {
  defaultValue: []
});
exports.productTypes = productTypes;