"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSearchPlugin = void 0;
var _nav = require("./layout/nav");
var _doc_links = require("../common/doc_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ServerlessSearchPlugin {
  setup(core, _setupDeps) {
    core.application.register({
      id: 'serverlessElasticsearch',
      title: 'Elasticsearch',
      appRoute: '/app/elasticsearch',
      async mount({
        element
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, services] = await core.getStartServices();
        const {
          security
        } = services;
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        const userProfile = await security.userProfiles.getCurrent();
        return await renderApp(element, coreStart, {
          userProfile,
          ...services
        });
      }
    });
    return {};
  }
  start(core, {
    serverless
  }) {
    serverless.setProjectHome('/app/elasticsearch');
    serverless.setSideNavComponent((0, _nav.createServerlessSearchSideNavComponent)(core, {
      serverless
    }));
    return {};
  }
  stop() {}
}
exports.ServerlessSearchPlugin = ServerlessSearchPlugin;