"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectClientPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _overview_panel = require("./overview_panel");
var _doc_links = require("../../../../common/doc_links");
require("./select_client.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectClientPanel = ({
  children
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.selectClient.description",
      defaultMessage: "Elastic builds and maintains clients in several popular languages and our community has contributed many more. Select your favorite language client or dive into the {console} to get started.",
      values: {
        console: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: http.basePath.prepend(`/app/dev_tools#/console`)
        }, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.description.console.link', {
          defaultMessage: 'Console'
        }))
      }
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.heading', {
      defaultMessage: 'Choose one'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row"
    }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.callout.title', {
        defaultMessage: 'Try it now in Console'
      }),
      size: "m",
      iconType: "iInCircle"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.callout.description', {
      defaultMessage: 'With Console, you can get started right away with our REST API’s. No installation required. '
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: http.basePath.prepend(`/app/dev_tools#/console`)
    }, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.callout.link', {
      defaultMessage: 'Try Console now'
    })))))),
    links: [{
      href: _doc_links.docLinks.elasticsearchClients,
      label: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.elasticsearchClientDocLink', {
        defaultMessage: 'Elasticsearch clients '
      })
    }, {
      href: _doc_links.docLinks.kibanaRunApiInConsole,
      label: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.apiRequestConsoleDocLink', {
        defaultMessage: 'Run API requests in Console '
      })
    }],
    title: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.title', {
      defaultMessage: 'Select your client'
    })
  });
};
exports.SelectClientPanel = SelectClientPanel;