"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestData = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _doc_links = require("../../../../common/doc_links");
var _code_box = require("../code_box");
var _languages = require("../languages/languages");
var _overview_panel = require("./overview_panel");
var _integrations_panel = require("./integrations_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IngestData = ({
  codeArguments,
  selectedLanguage,
  setSelectedLanguage
}) => {
  const [selectedIngestMethod, setSelectedIngestMethod] = (0, _react.useState)('ingestViaApi');
  return /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.ingestData.description', {
      defaultMessage: 'Add data to your data stream or index to make it searchable. Choose an ingestion method that fits your application and workflow.'
    }),
    leftPanelContent: selectedIngestMethod === 'ingestViaApi' ? /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
      code: "ingestData",
      codeArgs: codeArguments,
      languages: _languages.languageDefinitions,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }) : /*#__PURE__*/_react.default.createElement(_integrations_panel.IntegrationsPanel, null),
    links: [...(selectedLanguage.apiReference ? [{
      href: selectedLanguage.apiReference,
      label: _i18n.i18n.translate('xpack.serverlessSearch.ingestData.clientDocLink', {
        defaultMessage: '{languageName} API reference',
        values: {
          languageName: selectedLanguage.name
        }
      })
    }] : []), {
      href: _doc_links.docLinks.integrations,
      label: _i18n.i18n.translate('xpack.serverlessSearch.ingestData.integrationsLink', {
        defaultMessage: 'About Integrations'
      })
    }],
    title: _i18n.i18n.translate('xpack.serverlessSearch.ingestData.title', {
      defaultMessage: 'Ingest data'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.serverlessSearch.ingestData.ingestLegendLabel', {
        defaultMessage: 'Select an ingestion method'
      }),
      display: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    hasShadow: true,
    id: "ingestViaApi",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.ingestApiLabel', {
      defaultMessage: 'Ingest via API'
    }))),
    value: "ingestViaApi",
    checked: selectedIngestMethod === 'ingestViaApi',
    onChange: () => setSelectedIngestMethod('ingestViaApi')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.ingestApiDescription', {
    defaultMessage: 'The most flexible way to index data, enabling full control over your customization and optimization options.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    hasShadow: true,
    id: "ingestViaIntegration",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.ingestIntegrationLabel', {
      defaultMessage: 'Ingest via integration'
    }))),
    value: "ingestViaIntegration",
    checked: selectedIngestMethod === 'ingestViaIntegration',
    onChange: () => setSelectedIngestMethod('ingestViaIntegration')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.ingestIntegrationDescription', {
    defaultMessage: 'Specialized ingestion tools optimized for transforming data and shipping it to Elasticsearch.'
  })))));
};
exports.IngestData = IngestData;