"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docLinks = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESDocLinks {
  constructor() {
    (0, _defineProperty2.default)(this, "apiIntro", '');
    (0, _defineProperty2.default)(this, "beats", '');
    (0, _defineProperty2.default)(this, "connectors", '');
    (0, _defineProperty2.default)(this, "elasticsearchClients", '');
    (0, _defineProperty2.default)(this, "integrations", '');
    (0, _defineProperty2.default)(this, "jsApiReference", '');
    (0, _defineProperty2.default)(this, "jsAdvancedConfig", '');
    (0, _defineProperty2.default)(this, "jsBasicConfig", '');
    (0, _defineProperty2.default)(this, "jsClient", '');
    (0, _defineProperty2.default)(this, "kibanaRunApiInConsole", '');
    (0, _defineProperty2.default)(this, "logStash", '');
    (0, _defineProperty2.default)(this, "metadata", '');
    (0, _defineProperty2.default)(this, "roleDescriptors", '');
    (0, _defineProperty2.default)(this, "rubyAdvancedConfig", '');
    (0, _defineProperty2.default)(this, "rubyBasicConfig", '');
    (0, _defineProperty2.default)(this, "rubyClient", '');
    (0, _defineProperty2.default)(this, "rubyExamples", '');
    (0, _defineProperty2.default)(this, "securityApis", '');
  }
  setDocLinks(newDocLinks) {
    this.apiIntro = newDocLinks.apis.restApis;
    this.elasticsearchClients = newDocLinks.clients.guide;
    this.integrations = newDocLinks.serverlessSearch.integrations;
    this.jsAdvancedConfig = newDocLinks.clients.jsAdvancedConfig;
    this.jsApiReference = newDocLinks.clients.jsApiReference;
    this.jsBasicConfig = newDocLinks.clients.jsBasicConfig;
    this.jsClient = newDocLinks.clients.jsIntro;
    this.kibanaRunApiInConsole = newDocLinks.console.guide;
    this.metadata = newDocLinks.security.mappingRoles;
    this.roleDescriptors = newDocLinks.security.mappingRoles;
    this.rubyAdvancedConfig = newDocLinks.clients.rubyAdvancedConfig;
    this.rubyBasicConfig = newDocLinks.clients.rubyBasicConfig;
    this.rubyExamples = newDocLinks.clients.rubyExamples;
    this.rubyClient = newDocLinks.clients.rubyOverview;
    this.securityApis = newDocLinks.apis.securityApis;
  }
}
const docLinks = new ESDocLinks();
exports.docLinks = docLinks;