"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessObservabilityPlugin = void 0;
var _side_navigation = require("./components/side_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessObservabilityPlugin {
  setup(_core, _setupDeps) {
    return {};
  }
  start(core, setupDeps) {
    const {
      observabilityShared,
      serverless
    } = setupDeps;
    observabilityShared.setIsSidebarEnabled(false);
    serverless.setProjectHome('/app/observability/landing');
    serverless.setSideNavComponent((0, _side_navigation.getObservabilitySideNavComponent)(core, {
      serverless
    }));
    return {};
  }
  stop() {}
}
exports.ServerlessObservabilityPlugin = ServerlessObservabilityPlugin;