"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuleTypeId = exports.isRuleType = exports.flattenWithPrefix = void 0;
var _lodash = require("lodash");
var _rule_type_mappings = require("./rule_type_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isRuleType = ruleType => {
  return Object.keys(_rule_type_mappings.ruleTypeMappings).includes(ruleType);
};
exports.isRuleType = isRuleType;
const isRuleTypeId = ruleTypeId => {
  return Object.values(_rule_type_mappings.ruleTypeMappings).includes(ruleTypeId);
};
exports.isRuleTypeId = isRuleTypeId;
const flattenWithPrefix = (prefix, maybeObj) => {
  if (maybeObj != null && (0, _lodash.isPlainObject)(maybeObj)) {
    return Object.keys(maybeObj).reduce((acc, key) => {
      return {
        ...acc,
        ...flattenWithPrefix(`${prefix}.${key}`, maybeObj[key])
      };
    }, {});
  } else {
    return {
      [prefix]: maybeObj
    };
  }
};
exports.flattenWithPrefix = flattenWithPrefix;