"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExceptionListSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _os_type = require("../../common/os_type");
var _tags = require("../../common/tags");
var _description = require("../../common/description");
var _name = require("../../common/name");
var _underscore_version = require("../../common/underscore_version");
var _exception_list = require("../../common/exception_list");
var _id = require("../../common/id");
var _list_id = require("../../common/list_id");
var _meta = require("../../common/meta");
var _namespace_type = require("../../common/namespace_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateExceptionListSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  name: _name.name,
  type: _exception_list.exceptionListType
})), t.exact(t.partial({
  _version: _underscore_version._version,
  // defaults to undefined if not set during decode
  id: _id.id,
  // defaults to undefined if not set during decode
  list_id: _list_id.list_id,
  // defaults to undefined if not set during decode
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  namespace_type: _namespace_type.namespace_type,
  // defaults to 'single' if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags,
  // defaults to empty array if not set during decode
  version: _securitysolutionIoTsTypes.version // defaults to undefined if not set during decode
}))]);
exports.updateExceptionListSchema = updateExceptionListSchema;