"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalCreateExceptionListSchema = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var t = _interopRequireWildcard(require("io-ts"));
var _create_exception_list_schema = require("../../create_exception_list_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const internalCreateExceptionListSchema = t.intersection([t.exact(t.type({
  type: t.keyof({
    endpoint: null,
    endpoint_events: null,
    endpoint_host_isolation_exceptions: null,
    endpoint_blocklists: null
  })
})), t.exact(t.partial({
  list_id: t.keyof(_securitysolutionListConstants.ENDPOINT_ARTIFACT_LIST_IDS.reduce((mapOfListIds, listId) => {
    mapOfListIds[listId] = null;
    return mapOfListIds;
  }, {}))
})), _create_exception_list_schema.createExceptionListSchema]);
exports.internalCreateExceptionListSchema = internalCreateExceptionListSchema;