"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialSingleEventMetric = exports.getInitialSingleEventLogUsage = exports.getInitialRulesUsage = exports.getInitialMaxAvgMin = exports.getInitialEventLogUsage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Default detection rule usage count, split by type + elastic/custom
 */
const getInitialRulesUsage = () => ({
  query: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  threshold: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  eql: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  machine_learning: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  threat_match: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  new_terms: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  elastic_total: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  },
  custom_total: {
    enabled: 0,
    disabled: 0,
    alerts: 0,
    cases: 0,
    legacy_notifications_enabled: 0,
    legacy_notifications_disabled: 0,
    notifications_enabled: 0,
    notifications_disabled: 0
  }
});

/**
 * Returns the initial usage of event logs specific to rules.
 * This returns them for all rules, custom rules, and "elastic_rules"/"immutable rules"/pre-packaged rules
 * @returns The initial event log usage
 */
exports.getInitialRulesUsage = getInitialRulesUsage;
const getInitialEventLogUsage = () => ({
  all_rules: getInitialSingleEventLogUsage(),
  custom_rules: getInitialSingleEventLogUsage(),
  elastic_rules: getInitialSingleEventLogUsage()
});

/**
 * Returns the initial single event metric for a particular event log.
 * This returns the initial single event metric for either rules, custom rules, or "elastic_rules"/"immutable rules"/pre-packaged rules
 * @see getInitialEventLogUsage
 * @returns The initial event log usage for a single event metric.
 */
exports.getInitialEventLogUsage = getInitialEventLogUsage;
const getInitialSingleEventLogUsage = () => ({
  eql: getInitialSingleEventMetric(),
  threat_match: getInitialSingleEventMetric(),
  machine_learning: getInitialSingleEventMetric(),
  query: getInitialSingleEventMetric(),
  saved_query: getInitialSingleEventMetric(),
  threshold: getInitialSingleEventMetric(),
  total: {
    failures: 0,
    partial_failures: 0,
    succeeded: 0
  }
});

/**
 * Returns the initial single event metric.
 * This returns the initial single event metric for either rules, custom rules, or "elastic_rules"/"immutable rules"/pre-packaged rules
 * @see getInitialEventLogUsage
 * @returns The initial event log usage for a single event metric.
 */
exports.getInitialSingleEventLogUsage = getInitialSingleEventLogUsage;
const getInitialSingleEventMetric = () => ({
  failures: 0,
  top_failures: [],
  partial_failures: 0,
  top_partial_failures: [],
  succeeded: 0,
  index_duration: getInitialMaxAvgMin(),
  search_duration: getInitialMaxAvgMin(),
  enrichment_duration: getInitialMaxAvgMin(),
  gap_duration: getInitialMaxAvgMin(),
  gap_count: 0
});

/**
 * Returns the max, avg, or min for an event.
 * This returns the max, avg, or min for a single event metric.
 * @see getInitialEventLogUsage
 * @returns The max, avg, or min.
 */
exports.getInitialSingleEventMetric = getInitialSingleEventMetric;
const getInitialMaxAvgMin = () => ({
  max: 0.0,
  avg: 0.0,
  min: 0.0
});
exports.getInitialMaxAvgMin = getInitialMaxAvgMin;