"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalWeightForIdentifierType = exports.buildWeightingOfScoreByCategory = exports.buildCategoryWeights = exports.buildCategoryScoreDeclarations = exports.buildCategoryScoreAssignment = void 0;
var _lodash = require("lodash");
var _risk_engine = require("../../../common/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_CATEGORIES = Object.values(_risk_engine.RiskCategories);
const DEFAULT_CATEGORY_WEIGHTS = RISK_CATEGORIES.map(category => ({
  type: _risk_engine.RiskWeightTypes.riskCategory,
  value: category,
  host: 1,
  user: 1
}));

/*
 * This function and its use can be deleted once we've replaced our use of event.kind with a proper risk category field.
 */
const convertCategoryToEventKindValue = category => category === 'alerts' ? 'signal' : category;
const isGlobalIdentifierTypeWeight = weight => weight.type === _risk_engine.RiskWeightTypes.global;
const isRiskCategoryWeight = weight => weight.type === _risk_engine.RiskWeightTypes.riskCategory;
const getGlobalWeightForIdentifierType = ({
  identifierType,
  weights
}) => {
  var _weights$find;
  return weights === null || weights === void 0 ? void 0 : (_weights$find = weights.find(isGlobalIdentifierTypeWeight)) === null || _weights$find === void 0 ? void 0 : _weights$find[identifierType];
};
exports.getGlobalWeightForIdentifierType = getGlobalWeightForIdentifierType;
const getRiskCategoryWeights = weights => {
  var _weights$filter;
  return (_weights$filter = weights === null || weights === void 0 ? void 0 : weights.filter(isRiskCategoryWeight)) !== null && _weights$filter !== void 0 ? _weights$filter : [];
};
const getWeightForIdentifierType = (weight, identifierType) => {
  const configuredWeight = weight[identifierType];
  return typeof configuredWeight === 'number' ? configuredWeight : 1;
};
const buildCategoryScoreDeclarations = () => {
  const otherScoreDeclaration = `results['other_score'] = 0;`;
  return RISK_CATEGORIES.map(riskCategory => `results['${riskCategory}_score'] = 0;`).join('').concat(otherScoreDeclaration);
};
exports.buildCategoryScoreDeclarations = buildCategoryScoreDeclarations;
const buildCategoryWeights = userWeights => {
  const categoryWeights = getRiskCategoryWeights(userWeights);
  return Object.values((0, _lodash.merge)({}, (0, _lodash.keyBy)(DEFAULT_CATEGORY_WEIGHTS, 'value'), (0, _lodash.keyBy)(categoryWeights, 'value')));
};
exports.buildCategoryWeights = buildCategoryWeights;
const buildCategoryScoreAssignment = () => {
  const otherClause = `results['other_score'] += current_score;`;
  return RISK_CATEGORIES.map(category => `if (inputs[i].category == '${convertCategoryToEventKindValue(category)}') { results['${category}_score'] += current_score; }`).join(' else ').concat(` else { ${otherClause} }`);
};
exports.buildCategoryScoreAssignment = buildCategoryScoreAssignment;
const buildWeightingOfScoreByCategory = ({
  userWeights,
  identifierType
}) => {
  const otherClause = `weighted_score = score;`;
  const categoryWeights = buildCategoryWeights(userWeights);
  return categoryWeights.map(weight => `if (category == '${convertCategoryToEventKindValue(weight.value)}') { weighted_score = score * ${getWeightForIdentifierType(weight, identifierType)}; }`).join(' else ').concat(` else { ${otherClause} }`);
};
exports.buildWeightingOfScoreByCategory = buildWeightingOfScoreByCategory;