"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskEngineDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _configurations = require("./configurations");
var _create_datastream = require("./utils/create_datastream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RiskEngineDataClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "writerCache", new Map());
    this.options = options;
  }
  async getWriter({
    namespace
  }) {
    if (this.writerCache.get(namespace)) {
      return this.writerCache.get(namespace);
    }
    await this.initializeResources({
      namespace
    });
    return this.writerCache.get(namespace);
  }
  async initializeWriter(namespace) {
    const writer = {
      bulk: async () => {}
    };
    this.writerCache.set(namespace, writer);
    return writer;
  }
  async initializeResources({
    namespace = _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING
  }) {
    try {
      const esClient = await this.options.elasticsearchClientPromise;
      const indexPatterns = (0, _configurations.getIndexPattern)(namespace);
      const indexMetadata = {
        kibana: {
          version: this.options.kibanaVersion
        },
        managed: true,
        namespace
      };
      await Promise.all([(0, _server.createOrUpdateIlmPolicy)({
        logger: this.options.logger,
        esClient,
        name: _configurations.ilmPolicyName,
        policy: _configurations.ilmPolicy
      }), (0, _server.createOrUpdateComponentTemplate)({
        logger: this.options.logger,
        esClient,
        template: {
          name: _configurations.mappingComponentName,
          _meta: {
            managed: true
          },
          template: {
            settings: {},
            mappings: (0, _common.mappingFromFieldMap)(_configurations.riskFieldMap, 'strict')
          }
        },
        totalFieldsLimit: _configurations.totalFieldsLimit
      })]);
      await (0, _server.createOrUpdateIndexTemplate)({
        logger: this.options.logger,
        esClient,
        template: {
          name: indexPatterns.template,
          body: {
            data_stream: {
              hidden: true
            },
            index_patterns: [indexPatterns.alias],
            composed_of: [_configurations.mappingComponentName],
            template: {
              settings: {
                auto_expand_replicas: '0-1',
                hidden: true,
                'index.lifecycle': {
                  name: _configurations.ilmPolicyName
                },
                'index.mapping.total_fields.limit': _configurations.totalFieldsLimit
              },
              mappings: {
                dynamic: false,
                _meta: indexMetadata
              }
            },
            _meta: indexMetadata
          }
        }
      });
      await (0, _create_datastream.createDataStream)({
        logger: this.options.logger,
        esClient,
        totalFieldsLimit: _configurations.totalFieldsLimit,
        indexPatterns
      });
      this.initializeWriter(namespace);
    } catch (error) {
      this.options.logger.error(`Error initializing risk engine resources: ${error.message}`);
    }
  }
}
exports.RiskEngineDataClient = RiskEngineDataClient;