"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduleNotificationResponseActionsService = void 0;
var _lodash = require("lodash");
var _schemas = require("../../../../common/detection_engine/rule_response_actions/schemas");
var _osquery_response_action = require("./osquery_response_action");
var _endpoint_response_action = require("./endpoint_response_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduleNotificationResponseActionsService = ({
  osqueryCreateActionService,
  endpointAppContextService
}) => ({
  signals,
  responseActions
}) => {
  const alerts = signals.filter(alert => {
    var _alert$agent;
    return (_alert$agent = alert.agent) === null || _alert$agent === void 0 ? void 0 : _alert$agent.id;
  });
  (0, _lodash.each)(responseActions, responseAction => {
    if (responseAction.actionTypeId === _schemas.RESPONSE_ACTION_TYPES.OSQUERY && osqueryCreateActionService) {
      (0, _osquery_response_action.osqueryResponseAction)(responseAction, osqueryCreateActionService, {
        alerts
      });
    }
    if (responseAction.actionTypeId === _schemas.RESPONSE_ACTION_TYPES.ENDPOINT) {
      (0, _endpoint_response_action.endpointResponseAction)(responseAction, endpointAppContextService, {
        alerts
      });
    }
  });
};
exports.getScheduleNotificationResponseActionsService = getScheduleNotificationResponseActionsService;