"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleObjectsHealthClient = void 0;
var _health_stats_for_space = require("./aggregations/health_stats_for_space");
var _fetch_rule_by_id = require("./fetch_rule_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleObjectsHealthClient = rulesClient => {
  return {
    async calculateRuleHealth(args) {
      const rule = await (0, _fetch_rule_by_id.fetchRuleById)(rulesClient, args.rule_id);
      return {
        stats_at_the_moment: {
          rule
        },
        debug: {}
      };
    },
    async calculateSpaceHealth(args) {
      const aggs = (0, _health_stats_for_space.getSpaceHealthAggregation)();
      const aggregations = await rulesClient.aggregate({
        aggs
      });
      return {
        stats_at_the_moment: (0, _health_stats_for_space.normalizeSpaceHealthAggregationResult)(aggregations),
        debug: {
          rulesClient: {
            request: {
              aggs
            },
            response: {
              aggregations
            }
          }
        }
      };
    },
    async calculateClusterHealth(args) {
      // TODO: https://github.com/elastic/kibana/issues/125642 Implement
      return {
        stats_at_the_moment: {
          number_of_rules: {
            all: {
              total: 0,
              enabled: 0,
              disabled: 0
            },
            by_origin: {
              prebuilt: {
                total: 0,
                enabled: 0,
                disabled: 0
              },
              custom: {
                total: 0,
                enabled: 0,
                disabled: 0
              }
            },
            by_type: {},
            by_outcome: {}
          }
        },
        debug: {
          rulesClient: {
            request: {},
            response: {}
          }
        }
      };
    }
  };
};
exports.createRuleObjectsHealthClient = createRuleObjectsHealthClient;