"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zipRuleVersions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zipRuleVersions = (installedRules, baseRules, latestRules) => {
  const baseRulesMap = new Map(baseRules.map(r => [r.rule_id, r]));
  const latestRulesMap = new Map(latestRules.map(r => [r.rule_id, r]));
  const currentRulesMap = new Map(installedRules.map(r => [r.rule_id, r]));
  const uniqueRuleIds = new Set([...Array.from(baseRulesMap.keys()), ...Array.from(latestRulesMap.keys()), ...Array.from(currentRulesMap.keys())]);
  return new Map([...uniqueRuleIds].map(ruleId => {
    const base = baseRulesMap.get(ruleId);
    const target = latestRulesMap.get(ruleId);
    const current = currentRulesMap.get(ruleId);
    return [ruleId, {
      current,
      base,
      target
    }];
  }));
};
exports.zipRuleVersions = zipRuleVersions;