"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateFieldsDiffFor = void 0;
var _lodash = require("lodash");
var _three_way_diff = require("../../../../../../../common/detection_engine/prebuilt_rules/model/diff/three_way_diff/three_way_diff");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateFieldsDiffFor = (ruleVersions, fieldsDiffAlgorithms) => {
  const result = (0, _lodash.mapValues)(fieldsDiffAlgorithms, (calculateFieldDiff, fieldName) => {
    const fieldVersions = pickField(fieldName, ruleVersions);
    const fieldDiff = calculateFieldDiff(fieldVersions);
    return fieldDiff;
  });

  // TODO: try to improve strict typing and get rid of this "as" operator.
  return result;
};
exports.calculateFieldsDiffFor = calculateFieldsDiffFor;
const pickField = (fieldName, versions) => {
  return {
    base_version: versions.base_version !== _three_way_diff.MissingVersion ? versions.base_version[fieldName] : _three_way_diff.MissingVersion,
    current_version: versions.current_version[fieldName],
    target_version: versions.target_version[fieldName]
  };
};