"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrebuiltRulesStatusRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _prebuilt_rule_objects_client = require("../../logic/rule_objects/prebuilt_rule_objects_client");
var _fetch_rule_versions_triad = require("../../logic/rule_versions/fetch_rule_versions_triad");
var _get_version_buckets = require("../../model/rule_versions/get_version_buckets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrebuiltRulesStatusRoute = router => {
  router.get({
    path: _prebuilt_rules.GET_PREBUILT_RULES_STATUS_URL,
    validate: {},
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'alerting']);
      const soClient = ctx.core.savedObjects.client;
      const rulesClient = ctx.alerting.getRulesClient();
      const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
      const ruleObjectsClient = (0, _prebuilt_rule_objects_client.createPrebuiltRuleObjectsClient)(rulesClient);
      const ruleVersionsMap = await (0, _fetch_rule_versions_triad.fetchRuleVersionsTriad)({
        ruleAssetsClient,
        ruleObjectsClient
      });
      const {
        currentRules,
        installableRules,
        upgradeableRules,
        totalAvailableRules
      } = (0, _get_version_buckets.getVersionBuckets)(ruleVersionsMap);
      const body = {
        stats: {
          num_prebuilt_rules_installed: currentRules.length,
          num_prebuilt_rules_to_install: installableRules.length,
          num_prebuilt_rules_to_upgrade: upgradeableRules.length,
          num_prebuilt_rules_total_in_package: totalAvailableRules.length
        }
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getPrebuiltRulesStatusRoute = getPrebuiltRulesStatusRoute;