"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesBaseKibanaSubFeatureIds = exports.getCasesBaseKibanaFeature = exports.getCasesAppFeaturesConfig = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _common = require("@kbn/cases-plugin/common");
var _constants = require("../../../common/constants");
var _security_cases_kibana_sub_features = require("./security_cases_kibana_sub_features");
var _app_features = require("../../../common/types/app_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesCapabilities = (0, _common.createUICapabilities)();
const casesApiTags = (0, _common.getApiTags)(_constants.APP_ID);
const getCasesBaseKibanaFeature = () => ({
  id: _constants.CASES_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionCaseTitle', {
    defaultMessage: 'Cases'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.CASES_FEATURE_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  cases: [_constants.APP_ID],
  privileges: {
    all: {
      api: casesApiTags.all,
      app: [_constants.CASES_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      cases: {
        create: [_constants.APP_ID],
        read: [_constants.APP_ID],
        update: [_constants.APP_ID],
        push: [_constants.APP_ID]
      },
      savedObject: {
        all: [..._saved_objects.hiddenTypes],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.all
    },
    read: {
      api: casesApiTags.read,
      app: [_constants.CASES_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      cases: {
        read: [_constants.APP_ID]
      },
      savedObject: {
        all: [],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.read
    }
  }
});
exports.getCasesBaseKibanaFeature = getCasesBaseKibanaFeature;
const getCasesBaseKibanaSubFeatureIds = () => [_security_cases_kibana_sub_features.CasesSubFeatureId.deleteCases];

/**
 * Maps the AppFeatures keys to Kibana privileges that will be merged
 * into the base privileges config for the Security Cases app.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security Cases feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Cases subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Cases subFeature with the privilege `id` specified.
 */
exports.getCasesBaseKibanaSubFeatureIds = getCasesBaseKibanaSubFeatureIds;
const getCasesAppFeaturesConfig = () => ({
  [_app_features.AppFeatureCasesKey.casesConnectors]: {
    // TODO: Add cases connector configuration privileges
  }
});
exports.getCasesAppFeaturesConfig = getCasesAppFeaturesConfig;