"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsContent = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_conversation_store = require("../../../../assistant/use_conversation_store");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _timeline = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_timeline_events_count = require("../../../../common/hooks/use_timeline_events_count");
var _timeline2 = require("../../../store/timeline");
var _selectors = require("./selectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_license = require("../../../../common/hooks/use_license");
var _translations2 = require("../../../../assistant/content/conversations/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const HideShowContainer = _styledComponents.default.div.attrs(({
  $isVisible = false,
  isOverflowYScroll = false
}) => ({
  style: {
    display: $isVisible ? 'flex' : 'none',
    overflow: isOverflowYScroll ? 'hidden scroll' : 'hidden'
  }
}))`
  flex: 1;
`;
const AssistantTabContainer = _styledComponents.default.div`
  overflow-y: auto;
  width: 100%;
`;
const QueryTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../query_tab_content'))));
const EqlTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../eql_tab_content'))));
const GraphTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../graph_tab_content'))));
const NotesTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../notes_tab_content'))));
const PinnedTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pinned_tab_content'))));
const SessionTabContent = /*#__PURE__*/(0, _react2.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../session_tab_content'))));
const QueryTab = /*#__PURE__*/(0, _react2.memo)(({
  renderCellValue,
  rowRenderers,
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(QueryTabContent, {
  renderCellValue: renderCellValue,
  rowRenderers: rowRenderers,
  timelineId: timelineId
})));
QueryTab.displayName = 'QueryTab';
const EqlTab = /*#__PURE__*/(0, _react2.memo)(({
  renderCellValue,
  rowRenderers,
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(EqlTabContent, {
  renderCellValue: renderCellValue,
  rowRenderers: rowRenderers,
  timelineId: timelineId
})));
EqlTab.displayName = 'EqlTab';
const GraphTab = /*#__PURE__*/(0, _react2.memo)(({
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(GraphTabContent, {
  timelineId: timelineId
})));
GraphTab.displayName = 'GraphTab';
const NotesTab = /*#__PURE__*/(0, _react2.memo)(({
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(NotesTabContent, {
  timelineId: timelineId
})));
NotesTab.displayName = 'NotesTab';
const SessionTab = /*#__PURE__*/(0, _react2.memo)(({
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(SessionTabContent, {
  timelineId: timelineId
})));
SessionTab.displayName = 'SessionTab';
const PinnedTab = /*#__PURE__*/(0, _react2.memo)(({
  renderCellValue,
  rowRenderers,
  timelineId
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(PinnedTabContent, {
  renderCellValue: renderCellValue,
  rowRenderers: rowRenderers,
  timelineId: timelineId
})));
PinnedTab.displayName = 'PinnedTab';
const AssistantTab = /*#__PURE__*/(0, _react2.memo)(({
  isAssistantEnabled,
  renderCellValue,
  rowRenderers,
  timelineId,
  shouldRefocusPrompt
}) => /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
  fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  })
}, /*#__PURE__*/_react2.default.createElement(AssistantTabContainer, null, /*#__PURE__*/_react2.default.createElement(_elasticAssistant.Assistant, {
  isAssistantEnabled: isAssistantEnabled,
  conversationId: _translations2.TIMELINE_CONVERSATION_TITLE,
  shouldRefocusPrompt: shouldRefocusPrompt
}))));
AssistantTab.displayName = 'AssistantTab';
const ActiveTimelineTab = /*#__PURE__*/(0, _react2.memo)(({
  activeTimelineTab,
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineType,
  showTimeline
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const getTab = (0, _react2.useCallback)(tab => {
    switch (tab) {
      case _timeline.TimelineTabs.graph:
        return /*#__PURE__*/_react2.default.createElement(GraphTab, {
          timelineId: timelineId
        });
      case _timeline.TimelineTabs.notes:
        return /*#__PURE__*/_react2.default.createElement(NotesTab, {
          timelineId: timelineId
        });
      case _timeline.TimelineTabs.session:
        return /*#__PURE__*/_react2.default.createElement(SessionTab, {
          timelineId: timelineId
        });
      default:
        return null;
    }
  }, [timelineId]);
  const isGraphOrNotesTabs = (0, _react2.useMemo)(() => [_timeline.TimelineTabs.graph, _timeline.TimelineTabs.notes, _timeline.TimelineTabs.session].includes(activeTimelineTab), [activeTimelineTab]);
  const {
    conversations
  } = (0, _use_conversation_store.useConversationStore)();
  const hasTimelineConversationStarted = (0, _react2.useMemo)(() => conversations[_translations2.TIMELINE_CONVERSATION_TITLE].messages.length > 0, [conversations]);

  /* Future developer -> why are we doing that
   * It is really expansive to re-render the QueryTab because the drag/drop
   * Therefore, we are only hiding its dom when switching to another tab
   * to avoid mounting/un-mounting === re-render
   */
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.query === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.query}`
  }, /*#__PURE__*/_react2.default.createElement(QueryTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.pinned === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.pinned}`
  }, /*#__PURE__*/_react2.default.createElement(PinnedTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), timelineType === _api.TimelineType.default && /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: _timeline.TimelineTabs.eql === activeTimelineTab,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.eql}`
  }, /*#__PURE__*/_react2.default.createElement(EqlTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })), /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: isGraphOrNotesTabs,
    isOverflowYScroll: activeTimelineTab === _timeline.TimelineTabs.session,
    "data-test-subj": `timeline-tab-content-${_timeline.TimelineTabs.graph}-${_timeline.TimelineTabs.notes}`
  }, isGraphOrNotesTabs && getTab(activeTimelineTab)), hasAssistantPrivilege && /*#__PURE__*/_react2.default.createElement(HideShowContainer, {
    $isVisible: activeTimelineTab === _timeline.TimelineTabs.securityAssistant,
    isOverflowYScroll: activeTimelineTab === _timeline.TimelineTabs.securityAssistant,
    "data-test-subj": `timeline-tab-content-security-assistant`,
    css: (0, _react.css)`
              overflow: hidden !important;
            `
  }, (activeTimelineTab === _timeline.TimelineTabs.securityAssistant || hasTimelineConversationStarted) && /*#__PURE__*/_react2.default.createElement(AssistantTab, {
    isAssistantEnabled: isAssistantEnabled,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    shouldRefocusPrompt: showTimeline && activeTimelineTab === _timeline.TimelineTabs.securityAssistant
  })));
});
ActiveTimelineTab.displayName = 'ActiveTimelineTab';
const CountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiTab = (0, _styledComponents.default)(_eui.EuiTab)`
  .euiTab__content {
    display: flex;
    flex-direction: row;
    white-space: pre;
  }

  :focus {
    text-decoration: none;

    > span > span {
      text-decoration: underline;
    }
  }
`;
const TabsContentComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineFullScreen,
  timelineType,
  graphEventId,
  sessionViewConfig,
  timelineDescription
}) => {
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const getActiveTab = (0, _react2.useMemo)(() => (0, _selectors.getActiveTabSelector)(), []);
  const getShowTimeline = (0, _react2.useMemo)(() => (0, _selectors.getShowTimelineSelector)(), []);
  const getNumberOfPinnedEvents = (0, _react2.useMemo)(() => (0, _selectors.getPinnedEventSelector)(), []);
  const getAppNotes = (0, _react2.useMemo)(() => (0, _selectors.getNotesSelector)(), []);
  const getTimelineNoteIds = (0, _react2.useMemo)(() => (0, _selectors.getNoteIdsSelector)(), []);
  const getTimelinePinnedEventNotes = (0, _react2.useMemo)(() => (0, _selectors.getEventIdToNoteIdsSelector)(), []);
  const activeTab = (0, _use_selector.useShallowEqualSelector)(state => getActiveTab(state, timelineId));
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => getShowTimeline(state, timelineId));
  const numberOfPinnedEvents = (0, _use_selector.useShallowEqualSelector)(state => getNumberOfPinnedEvents(state, timelineId));
  const globalTimelineNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNoteIds(state, timelineId));
  const eventIdToNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelinePinnedEventNotes(state, timelineId));
  const appNotes = (0, _use_selector.useDeepEqualSelector)(state => getAppNotes(state));
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const allTimelineNoteIds = (0, _react2.useMemo)(() => {
    const eventNoteIds = Object.values(eventIdToNoteIds).reduce((acc, v) => [...acc, ...v], []);
    return [...globalTimelineNoteIds, ...eventNoteIds];
  }, [globalTimelineNoteIds, eventIdToNoteIds]);
  const numberOfNotes = (0, _react2.useMemo)(() => appNotes.filter(appNote => allTimelineNoteIds.includes(appNote.id)).length + ((0, _fp.isEmpty)(timelineDescription) ? 0 : 1), [appNotes, allTimelineNoteIds, timelineDescription]);
  const setActiveTab = (0, _react2.useCallback)(tab => {
    dispatch(_timeline2.timelineActions.setActiveTabTimeline({
      id: timelineId,
      activeTab: tab
    }));
  }, [dispatch, timelineId]);
  const setQueryAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.query);
  }, [setActiveTab]);
  const setEqlAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.eql);
  }, [setActiveTab]);
  const setGraphAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.graph);
  }, [setActiveTab]);
  const setNotesAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.notes);
  }, [setActiveTab]);
  const setPinnedAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.pinned);
  }, [setActiveTab]);
  const setSessionAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.session);
  }, [setActiveTab]);
  const setSecurityAssistantAsActiveTab = (0, _react2.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.securityAssistant);
  }, [setActiveTab]);
  (0, _react2.useEffect)(() => {
    if (!graphEventId && activeTab === _timeline.TimelineTabs.graph) {
      setQueryAsActiveTab();
    }
  }, [activeTab, graphEventId, setQueryAsActiveTab]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, !timelineFullScreen && /*#__PURE__*/_react2.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.query}`,
    onClick: setQueryAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.query,
    disabled: false,
    key: _timeline.TimelineTabs.query
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.QUERY_TAB), showTimeline && /*#__PURE__*/_react2.default.createElement(_use_timeline_events_count.TimelineEventsCountBadge, null)), timelineType === _api.TimelineType.default && /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.eql}`,
    onClick: setEqlAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.eql,
    disabled: false,
    key: _timeline.TimelineTabs.eql
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.EQL_TAB), showTimeline && /*#__PURE__*/_react2.default.createElement(_use_timeline_events_count.EqlEventsCountBadge, null)), /*#__PURE__*/_react2.default.createElement(_eui.EuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.graph}`,
    onClick: setGraphAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.graph,
    disabled: !graphEventId,
    key: _timeline.TimelineTabs.graph
  }, i18n.ANALYZER_TAB), isEnterprisePlus && /*#__PURE__*/_react2.default.createElement(_eui.EuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.session}`,
    onClick: setSessionAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.session,
    disabled: sessionViewConfig === null,
    key: _timeline.TimelineTabs.session
  }, i18n.SESSION_TAB), /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.notes}`,
    onClick: setNotesAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.notes,
    disabled: timelineType === _api.TimelineType.template,
    key: _timeline.TimelineTabs.notes
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.NOTES_TAB), showTimeline && numberOfNotes > 0 && timelineType === _api.TimelineType.default && /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(CountBadge, null, numberOfNotes))), /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.pinned}`,
    onClick: setPinnedAsActiveTab,
    disabled: timelineType === _api.TimelineType.template,
    isSelected: activeTab === _timeline.TimelineTabs.pinned,
    key: _timeline.TimelineTabs.pinned
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.PINNED_TAB), showTimeline && numberOfPinnedEvents > 0 && timelineType === _api.TimelineType.default && /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(CountBadge, null, numberOfPinnedEvents))), hasAssistantPrivilege && /*#__PURE__*/_react2.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.securityAssistant}`,
    onClick: setSecurityAssistantAsActiveTab,
    disabled: timelineType === _api.TimelineType.template,
    isSelected: activeTab === _timeline.TimelineTabs.securityAssistant,
    key: _timeline.TimelineTabs.securityAssistant
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.SECURITY_ASSISTANT))), /*#__PURE__*/_react2.default.createElement(ActiveTimelineTab, {
    activeTimelineTab: activeTab,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: timelineDescription,
    showTimeline: showTimeline
  }));
};
const TabsContent = /*#__PURE__*/(0, _react2.memo)(TabsContentComponent);
exports.TabsContent = TabsContent;