"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PinnedTabContentComponent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _timeline = require("../../../store/timeline");
var _containers = require("../../../containers");
var _default_headers = require("../body/column_headers/default_headers");
var _body = require("../body");
var _footer = require("../footer");
var _default_config = require("../../../../detections/components/alerts_table/default_config");
var _event_details_width_context = require("../../../../common/components/events_viewer/event_details_width_context");
var _model = require("../../../../common/store/sourcerer/model");
var _defaults = require("../../../store/timeline/defaults");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _helpers = require("../helpers");
var _timeline2 = require("../../../../../common/types/timeline");
var _side_panel = require("../../side_panel");
var _exit_full_screen = require("../../../../common/components/exit_full_screen");
var _control_columns = require("../body/control_columns");
var _use_license = require("../../../../common/hooks/use_license");
var _header_actions = require("../../../../common/components/header_actions/header_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  overflow-y: hidden;
  flex: 1;

  .euiFlyoutBody__overflow {
    overflow: hidden;
    mask-image: none;
  }

  .euiFlyoutBody__overflowContent {
    padding: 0;
    height: 100%;
    display: flex;
  }
`;
const StyledEuiFlyoutFooter = (0, _styledComponents.default)(_eui.EuiFlyoutFooter)`
  background: none;
  padding: 0;

  &.euiFlyoutFooter {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeS} 0 0 0;`}
  }
`;
const ExitFullScreenContainer = _styledComponents.default.div`
  width: 180px;
`;
const FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0;
  width: 100%;
  overflow: hidden;
`;
const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
`;
const VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
VerticalRule.displayName = 'VerticalRule';
const trailingControlColumns = []; // stable reference

const PinnedTabContentComponent = ({
  columns,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  pinnedEventIds,
  onEventClosed,
  renderCellValue,
  rowRenderers,
  showExpandedDetails,
  sort
}) => {
  const {
    browserFields,
    dataViewId,
    loading: loadingSourcerer,
    runtimeMappings,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    setTimelineFullScreen,
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 6 : 5;
  const filterQuery = (0, _react.useMemo)(() => {
    if ((0, _fp.isEmpty)(pinnedEventIds)) {
      return '';
    }
    const filterObj = Object.entries(pinnedEventIds).reduce((acc, [pinnedId, isPinned]) => {
      if (isPinned) {
        return {
          ...acc,
          bool: {
            ...acc.bool,
            should: [...acc.bool.should, {
              match_phrase: {
                _id: pinnedId
              }
            }]
          }
        };
      }
      return acc;
    }, {
      bool: {
        should: [],
        minimum_should_match: 1
      }
    });
    try {
      return JSON.stringify(filterObj);
    } catch {
      return '';
    }
  }, [pinnedEventIds]);
  const timelineQueryFields = (0, _react.useMemo)(() => {
    const columnsHeader = (0, _fp.isEmpty)(columns) ? _default_headers.defaultHeaders : columns;
    const columnFields = columnsHeader.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  }, [columns]);
  const timelineQuerySortField = (0, _react.useMemo)(() => sort.map(({
    columnId,
    columnType,
    esTypes,
    sortDirection
  }) => ({
    field: columnId,
    type: columnType,
    direction: sortDirection,
    esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : []
  })), [sort]);
  const [isQueryLoading, {
    events,
    totalCount,
    pageInfo,
    loadPage,
    updatedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    endDate: '',
    id: `pinned-${timelineId}`,
    indexNames: selectedPatterns,
    dataViewId,
    fields: timelineQueryFields,
    limit: itemsPerPage,
    filterQuery,
    runtimeMappings,
    skip: filterQuery === '',
    startDate: '',
    sort: timelineQuerySortField,
    timerangeKind: undefined
  });
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    onEventClosed({
      tabType: _timeline2.TimelineTabs.pinned,
      id: timelineId
    });
  }, [timelineId, onEventClosed]);
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT).map(x => ({
    ...x,
    headerCellRender: _header_actions.HeaderActions
  })), [ACTION_BUTTON_COUNT]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FullWidthFlexGroup, {
    "data-test-subj": `${_timeline2.TimelineTabs.pinned}-tab`
  }, /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 2
  }, timelineFullScreen && setTimelineFullScreen != null && /*#__PURE__*/_react.default.createElement(ExitFullScreenContainer, null, /*#__PURE__*/_react.default.createElement(_exit_full_screen.ExitFullScreen, {
    fullScreen: timelineFullScreen,
    setFullScreen: setTimelineFullScreen
  })), /*#__PURE__*/_react.default.createElement(_event_details_width_context.EventDetailsWidthProvider, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, {
    "data-test-subj": `${_timeline2.TimelineTabs.pinned}-tab-flyout-body`,
    className: "timeline-flyout-body"
  }, /*#__PURE__*/_react.default.createElement(_body.StatefulBody, {
    activePage: pageInfo.activePage,
    browserFields: browserFields,
    data: events,
    id: timelineId,
    refetch: refetch,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    sort: sort,
    tabType: _timeline2.TimelineTabs.pinned,
    totalPages: (0, _helpers.calculateTotalPages)({
      itemsCount: totalCount,
      itemsPerPage
    }),
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  })), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutFooter, {
    "data-test-subj": `${_timeline2.TimelineTabs.pinned}-tab-flyout-footer`,
    className: "timeline-flyout-footer"
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    activePage: pageInfo.activePage,
    "data-test-subj": "timeline-footer",
    updatedAt: updatedAt,
    height: _footer.footerHeight,
    id: timelineId,
    isLive: false,
    isLoading: isQueryLoading || loadingSourcerer,
    itemsCount: events.length,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    onChangePage: loadPage,
    totalCount: totalCount
  })))), showExpandedDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    handleOnPanelClosed: handleOnPanelClosed,
    runtimeMappings: runtimeMappings,
    tabType: _timeline2.TimelineTabs.pinned,
    scopeId: timelineId
  })))));
};
exports.PinnedTabContentComponent = PinnedTabContentComponent;
const makeMapStateToProps = () => {
  const getTimeline = _timeline.timelineSelectors.getTimelineByIdSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline, _expandedDetail$Timel;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const {
      columns,
      expandedDetail,
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      sort
    } = timeline;
    return {
      columns,
      timelineId,
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      showExpandedDetails: !!expandedDetail[_timeline2.TimelineTabs.pinned] && !!((_expandedDetail$Timel = expandedDetail[_timeline2.TimelineTabs.pinned]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView),
      sort
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = (dispatch, {
  timelineId
}) => ({
  onEventClosed: args => {
    dispatch(_timeline.timelineActions.toggleDetailPanel(args));
  }
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const PinnedTabContent = connector( /*#__PURE__*/_react.default.memo(PinnedTabContentComponent, (prevProps, nextProps) => prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.onEventClosed === nextProps.onEventClosed && prevProps.showExpandedDetails === nextProps.showExpandedDetails && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions) && (0, _fastDeepEqual.default)(prevProps.pinnedEventIds, nextProps.pinnedEventIds) && (0, _fastDeepEqual.default)(prevProps.sort, nextProps.sort)));

// eslint-disable-next-line import/no-default-export
exports.default = PinnedTabContent;