"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineContext = exports.StatefulTimeline = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _timeline = require("../../store/timeline");
var _defaults = require("../../store/timeline/defaults");
var _default_headers = require("./body/column_headers/default_headers");
var _model = require("../../../common/store/sourcerer/model");
var _header = require("../flyout/header");
var _api = require("../../../../common/types/timeline/api");
var _use_selector = require("../../../common/hooks/use_selector");
var _active_timeline_context = require("../../containers/active_timeline_context");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _tabs_content = require("./tabs_content");
var _styles = require("./styles");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _exit_full_screen = require("../../../common/components/exit_full_screen");
var _use_resolve_conflict = require("../../../common/hooks/use_resolve_conflict");
var _store = require("../../../common/store");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineTemplateBadge = _styledComponents.default.div`
  background: ${({
  theme
}) => theme.eui.euiColorVis3_behindText};
  color: #fff;
  padding: 10px 15px;
  font-size: 0.8em;
`;
const TimelineContext = /*#__PURE__*/(0, _react.createContext)({
  timelineId: null
});
exports.TimelineContext = TimelineContext;
const TimelineSavingProgressComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const isSaving = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isSaving;
  });
  return isSaving ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "primary",
    position: "absolute"
  }) : null;
};
const TimelineSavingProgress = /*#__PURE__*/_react.default.memo(TimelineSavingProgressComponent);
const StatefulTimelineComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const scopeIdSelector = (0, _react.useMemo)(() => _store.sourcererSelectors.scopeIdSelector(), []);
  const {
    selectedPatterns: selectedPatternsSourcerer,
    selectedDataViewId: selectedDataViewIdSourcerer
  } = (0, _use_selector.useDeepEqualSelector)(state => scopeIdSelector(state, _model.SourcererScopeName.timeline));
  const {
    dataViewId: selectedDataViewIdTimeline,
    indexNames: selectedPatternsTimeline,
    graphEventId,
    savedObjectId,
    timelineType,
    description,
    sessionViewConfig
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return (0, _fp.pick)(['indexNames', 'dataViewId', 'graphEventId', 'savedObjectId', 'timelineType', 'description', 'sessionViewConfig'], (_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults);
  });
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  (0, _react.useEffect)(() => {
    if (!savedObjectId) {
      dispatch(_timeline.timelineActions.createTimeline({
        id: timelineId,
        columns: _default_headers.defaultHeaders,
        dataViewId: selectedDataViewIdSourcerer,
        indexNames: selectedPatternsSourcerer,
        expandedDetail: _active_timeline_context.activeTimeline.getExpandedDetail(),
        show: false
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSourcererChange = (0, _react.useCallback)(() => {
    if (
    // timeline not initialized, so this must be initial state and not user change
    !savedObjectId || selectedDataViewIdSourcerer == null ||
    // initial state will get set on create
    selectedDataViewIdTimeline === null && selectedPatternsTimeline.length === 0 ||
    // don't update if no change
    selectedDataViewIdTimeline === selectedDataViewIdSourcerer && selectedPatternsTimeline.sort().join() === selectedPatternsSourcerer.sort().join()) {
      return;
    }
    dispatch(_timeline.timelineActions.updateDataView({
      dataViewId: selectedDataViewIdSourcerer,
      id: timelineId,
      indexNames: selectedPatternsSourcerer
    }));
  }, [dispatch, savedObjectId, selectedDataViewIdSourcerer, selectedDataViewIdTimeline, selectedPatternsSourcerer, selectedPatternsTimeline, timelineId]);
  (0, _react.useEffect)(() => {
    onSourcererChange();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedDataViewIdSourcerer, selectedPatternsSourcerer]);
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur;
    const exitFullScreenButton = (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : _containerElement$cur.querySelector(_exit_full_screen.EXIT_FULL_SCREEN_CLASS_NAME);
    if (exitFullScreenButton != null) {
      exitFullScreenButton.focus();
    } else {
      var _containerElement$cur2, _containerElement$cur3;
      (_containerElement$cur2 = containerElement.current) === null || _containerElement$cur2 === void 0 ? void 0 : (_containerElement$cur3 = _containerElement$cur2.querySelector('.globalFilterBar__addButton')) === null || _containerElement$cur3 === void 0 ? void 0 : _containerElement$cur3.focus();
    }
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur4, _containerElement$cur5;
    (_containerElement$cur4 = containerElement.current) === null || _containerElement$cur4 === void 0 ? void 0 : (_containerElement$cur5 = _containerElement$cur4.querySelector(`.${_helpers.EVENTS_COUNT_BUTTON_CLASS_NAME}`)) === null || _containerElement$cur5 === void 0 ? void 0 : _containerElement$cur5.focus();
  }, [containerElement]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const timelineContext = (0, _react.useMemo)(() => ({
    timelineId
  }), [timelineId]);
  const resolveConflictComponent = (0, _use_resolve_conflict.useResolveConflict)();
  return /*#__PURE__*/_react.default.createElement(TimelineContext.Provider, {
    value: timelineContext
  }, /*#__PURE__*/_react.default.createElement(_styles.TimelineContainer, {
    "data-test-subj": "timeline",
    "data-timeline-id": timelineId,
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(TimelineSavingProgress, {
    timelineId: timelineId
  }), timelineType === _api.TimelineType.template && /*#__PURE__*/_react.default.createElement(TimelineTemplateBadge, null, i18n.TIMELINE_TEMPLATE), resolveConflictComponent, /*#__PURE__*/_react.default.createElement(_styles.HideShowContainer, {
    $isVisible: !timelineFullScreen,
    "data-test-subj": "timeline-hide-show-container"
  }, /*#__PURE__*/_react.default.createElement(_header.FlyoutHeaderPanel, {
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(_header.FlyoutHeader, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_tabs_content.TabsContent, {
    graphEventId: graphEventId,
    sessionViewConfig: sessionViewConfig,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: description,
    timelineFullScreen: timelineFullScreen
  })));
};
StatefulTimelineComponent.displayName = 'StatefulTimelineComponent';
const StatefulTimeline = /*#__PURE__*/_react.default.memo(StatefulTimelineComponent);
exports.StatefulTimeline = StatefulTimeline;