"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeekConnLogDictionay = exports.sha1StringRenderer = exports.moduleStringRenderer = exports.md5StringRenderer = exports.extractStateValue = exports.extractStateLink = exports.droppedStringRenderer = exports.defaultStringRenderer = exports.constructDroppedValue = exports.ZeekSignature = exports.TotalVirusLinkSha = exports.Link = exports.DraggableZeekElement = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggable_wrapper = require("../../../../../../common/components/drag_and_drop/draggable_wrapper");
var _helpers = require("../../../../../../common/components/drag_and_drop/helpers");
var _links = require("../../../../../../common/components/links");
var _provider = require("../../../data_providers/provider");
var _data_provider = require("../../../data_providers/data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Badge = (0, _styledComponents.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
const TokensFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 3px;
`;
TokensFlexItem.displayName = 'TokensFlexItem';
const LinkFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 6px;
`;
LinkFlexItem.displayName = 'LinkFlexItem';
const defaultStringRenderer = value => value;
exports.defaultStringRenderer = defaultStringRenderer;
const moduleStringRenderer = value => {
  const split = value.split('.');
  if (split.length >= 2 && split[1] != null) {
    if (split[1] !== '') {
      return split[1];
    } else {
      return split[0];
    }
  } else {
    return value;
  }
};
exports.moduleStringRenderer = moduleStringRenderer;
const droppedStringRenderer = value => `Dropped:${value}`;
exports.droppedStringRenderer = droppedStringRenderer;
const md5StringRenderer = value => `md5: ${value.substr(0, 7)}...`;
exports.md5StringRenderer = md5StringRenderer;
const sha1StringRenderer = value => `sha1: ${value.substr(0, 7)}...`;
exports.sha1StringRenderer = sha1StringRenderer;
const DraggableZeekElement = /*#__PURE__*/_react.default.memo(({
  id,
  field,
  isDraggable,
  value,
  stringRenderer = defaultStringRenderer
}) => {
  const dataProviderProp = (0, _react.useMemo)(() => ({
    and: [],
    enabled: true,
    id: (0, _helpers.escapeDataProviderId)(`draggable-zeek-element-draggable-wrapper-${id}-${field}-${value}`),
    name: String(value),
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field,
      value: String(value),
      operator: _data_provider.IS_OPERATOR
    }
  }), [field, id, value]);
  const render = (0, _react.useCallback)((dataProvider, _, snapshot) => snapshot.isDragging ? /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DragEffects, null, /*#__PURE__*/_react.default.createElement(_provider.Provider, {
    dataProvider: dataProvider
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "badge-tooltip",
    content: field
  }, /*#__PURE__*/_react.default.createElement(Badge, {
    iconType: "tag",
    color: "hollow",
    title: ""
  }, stringRenderer(String(value)))), [field, stringRenderer, value]);
  return value != null ? /*#__PURE__*/_react.default.createElement(TokensFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DraggableWrapper, {
    dataProvider: dataProviderProp,
    isDraggable: isDraggable,
    render: render,
    isAggregatable: true,
    fieldType: 'keyword'
  })) : null;
});
exports.DraggableZeekElement = DraggableZeekElement;
DraggableZeekElement.displayName = 'DraggableZeekElement';
const Link = /*#__PURE__*/_react.default.memo(({
  value,
  link
}) => {
  if (value != null) {
    if (link != null) {
      return /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
        link: link
      }, value)));
    } else {
      return /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
        link: value
      })));
    }
  } else {
    return null;
  }
});
exports.Link = Link;
Link.displayName = 'Link';
const TotalVirusLinkSha = /*#__PURE__*/_react.default.memo(({
  value
}) => value != null ? /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_links.ReputationLink, {
  domain: value,
  overflowIndexStart: 1,
  showDomain: true,
  "data-test-subj": "reputationLinkSha"
}))) : null);
exports.TotalVirusLinkSha = TotalVirusLinkSha;
TotalVirusLinkSha.displayName = 'TotalVirusLinkSha';

// English Text for these codes are shortened from
// https://docs.zeek.org/en/stable/scripts/base/protocols/conn/main.bro.html
const zeekConnLogDictionay = {
  S0: i18n.S0,
  S1: i18n.S1,
  S2: i18n.S2,
  S3: i18n.S3,
  SF: i18n.SF,
  REJ: i18n.REJ,
  RSTO: i18n.RSTO,
  RSTR: i18n.RSTR,
  RSTOS0: i18n.RSTOS0,
  RSTRH: i18n.RSTRH,
  SH: i18n.SH,
  SHR: i18n.SHR,
  OTH: i18n.OTH
};
exports.zeekConnLogDictionay = zeekConnLogDictionay;
const extractStateLink = state => {
  if (state != null) {
    const lookup = zeekConnLogDictionay[state];
    if (lookup != null) {
      return `${state} ${lookup}`;
    } else {
      return state;
    }
  } else {
    return null;
  }
};
exports.extractStateLink = extractStateLink;
const extractStateValue = state => state != null && zeekConnLogDictionay[state] != null ? zeekConnLogDictionay[state] : null;
exports.extractStateValue = extractStateValue;
const constructDroppedValue = dropped => dropped != null ? String(dropped) : null;
exports.constructDroppedValue = constructDroppedValue;
const ZeekSignature = /*#__PURE__*/_react.default.memo(({
  data,
  isDraggable,
  timelineId
}) => {
  const id = `zeek-signature-draggable-zeek-element-${timelineId}-${data._id}`;
  const sessionId = (0, _fp.get)('zeek.session_id[0]', data);
  const dataSet = (0, _fp.get)('event.dataset[0]', data);
  const sslVersion = (0, _fp.get)('zeek.ssl.version[0]', data);
  const cipher = (0, _fp.get)('zeek.ssl.cipher[0]', data);
  const state = (0, _fp.get)('zeek.connection.state[0]', data);
  const history = (0, _fp.get)('zeek.connection.history[0]', data);
  const note = (0, _fp.get)('zeek.notice.note[0]', data);
  const noteMsg = (0, _fp.get)('zeek.notice.msg[0]', data);
  const dropped = constructDroppedValue((0, _fp.get)('zeek.notice.dropped[0]', data));
  const dnsQuery = (0, _fp.get)('zeek.dns.query[0]', data);
  const qClassName = (0, _fp.get)('zeek.dns.qclass_name[0]', data);
  const httpMethod = (0, _fp.get)('http.request.method[0]', data);
  const httpResponseStatusCode = (0, _fp.get)('http.response.status_code[0]', data);
  const urlOriginal = (0, _fp.get)('url.original[0]', data);
  const fileSha1 = (0, _fp.get)('zeek.files.sha1[0]', data);
  const filemd5 = (0, _fp.get)('zeek.files.md5[0]', data);
  const stateLink = extractStateLink(state);
  const stateValue = extractStateValue(state);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.session_id",
    isDraggable: isDraggable,
    value: sessionId
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "event.dataset",
    isDraggable: isDraggable,
    value: dataSet,
    stringRenderer: moduleStringRenderer
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.files.sha1",
    isDraggable: isDraggable,
    value: fileSha1,
    stringRenderer: sha1StringRenderer
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.files.md5",
    isDraggable: isDraggable,
    value: filemd5,
    stringRenderer: md5StringRenderer
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.notice.dropped",
    isDraggable: isDraggable,
    value: dropped,
    stringRenderer: droppedStringRenderer
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.ssl.version",
    isDraggable: isDraggable,
    value: sslVersion
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.ssl.cipher",
    isDraggable: isDraggable,
    value: cipher
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.connection.state",
    isDraggable: isDraggable,
    value: state
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "http.request.method",
    isDraggable: isDraggable,
    value: httpMethod
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.connection.history",
    isDraggable: isDraggable,
    value: history
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.notice.note",
    isDraggable: isDraggable,
    value: note
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.dns.query",
    isDraggable: isDraggable,
    value: dnsQuery
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "zeek.dns.qclass_name",
    isDraggable: isDraggable,
    value: qClassName
  }), /*#__PURE__*/_react.default.createElement(DraggableZeekElement, {
    id: id,
    field: "http.response.status_code",
    isDraggable: isDraggable,
    value: httpResponseStatusCode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(Link, {
    link: stateLink,
    value: stateValue
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: cipher
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: dnsQuery
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: noteMsg
  }), /*#__PURE__*/_react.default.createElement(Link, {
    value: urlOriginal
  }), /*#__PURE__*/_react.default.createElement(TotalVirusLinkSha, {
    value: fileSha1
  })));
});
exports.ZeekSignature = ZeekSignature;
ZeekSignature.displayName = 'ZeekSignature';