"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHR = exports.SH = exports.SF = exports.S3 = exports.S2 = exports.S1 = exports.S0 = exports.RSTRH = exports.RSTR = exports.RSTOS0 = exports.RSTO = exports.REJ = exports.OTH = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// English Text for these codes are shortened from
// https://docs.zeek.org/en/stable/scripts/base/protocols/conn/main.bro.html
const S0 = _i18n.i18n.translate('xpack.securitySolution.zeek.s0Description', {
  defaultMessage: 'Connection attempt seen, no reply'
});
exports.S0 = S0;
const S1 = _i18n.i18n.translate('xpack.securitySolution.zeek.s1Description', {
  defaultMessage: 'Connection established, not terminated'
});
exports.S1 = S1;
const S2 = _i18n.i18n.translate('xpack.securitySolution.zeek.s2Description', {
  defaultMessage: 'Connection established and close attempt by originator seen (but no reply from responder)'
});
exports.S2 = S2;
const S3 = _i18n.i18n.translate('xpack.securitySolution.zeek.s3Description', {
  defaultMessage: 'Connection established and close attempt by responder seen (but no reply from originator)'
});
exports.S3 = S3;
const SF = _i18n.i18n.translate('xpack.securitySolution.zeek.sfDescription', {
  defaultMessage: 'Normal SYN/FIN completion'
});
exports.SF = SF;
const REJ = _i18n.i18n.translate('xpack.securitySolution.zeek.rejDescription', {
  defaultMessage: 'Connection attempt rejected'
});
exports.REJ = REJ;
const RSTO = _i18n.i18n.translate('xpack.securitySolution.zeek.rstoODescription', {
  defaultMessage: 'Connection established, originator aborted (sent a RST)'
});
exports.RSTO = RSTO;
const RSTR = _i18n.i18n.translate('xpack.securitySolution.zeek.rstrDescription', {
  defaultMessage: 'Established, responder aborted'
});
exports.RSTR = RSTR;
const RSTOS0 = _i18n.i18n.translate('xpack.securitySolution.zeek.rstosoDescription', {
  defaultMessage: 'Originator sent a SYN followed by a RST, no SYN-ACK from the responder'
});
exports.RSTOS0 = RSTOS0;
const RSTRH = _i18n.i18n.translate('xpack.securitySolution.zeek.rstrhDescription', {
  defaultMessage: 'Responder sent a SYN ACK followed by a RST, no SYN from the (purported) originator'
});
exports.RSTRH = RSTRH;
const SH = _i18n.i18n.translate('xpack.securitySolution.zeek.shDescription', {
  defaultMessage: 'Originator sent a SYN followed by a FIN, no SYN ACK from the responder'
});
exports.SH = SH;
const SHR = _i18n.i18n.translate('xpack.securitySolution.zeek.shrDescription', {
  defaultMessage: 'Responder sent a SYN ACK followed by a FIN, no SYN from the originator'
});
exports.SHR = SHR;
const OTH = _i18n.i18n.translate('xpack.securitySolution.zeek.othDescription', {
  defaultMessage: 'No SYN seen, just midstream traffic'
});
exports.OTH = OTH;