"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRowView = exports.ThreatMatchRow = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../common/cti/constants");
var _match_details = require("./match_details");
var _indicator_details = require("./indicator_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThreatMatchRow = ({
  contextId,
  data,
  eventId,
  isDraggable
}) => {
  const props = {
    contextId,
    eventId,
    indicatorReference: (0, _fp.getOr)([], _constants.REFERENCE, data)[0],
    feedName: (0, _fp.getOr)([], _constants.FEED_NAME, data)[0],
    indicatorType: (0, _fp.getOr)([], _constants.MATCHED_TYPE, data)[0],
    isDraggable,
    sourceField: (0, _fp.get)(_constants.MATCHED_FIELD, data)[0],
    sourceValue: (0, _fp.get)(_constants.MATCHED_ATOMIC, data)[0]
  };
  return /*#__PURE__*/_react.default.createElement(ThreatMatchRowView, props);
};
exports.ThreatMatchRow = ThreatMatchRow;
const ThreatMatchRowView = ({
  contextId,
  eventId,
  feedName,
  indicatorReference,
  indicatorType,
  isDraggable,
  sourceField,
  sourceValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "threat-match-row",
    gutterSize: "s",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_match_details.MatchDetails, {
    contextId: contextId,
    eventId: eventId,
    isDraggable: isDraggable,
    sourceField: sourceField,
    sourceValue: sourceValue
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_indicator_details.IndicatorDetails, {
    contextId: contextId,
    eventId: eventId,
    feedName: feedName,
    indicatorReference: indicatorReference,
    indicatorType: indicatorType,
    isDraggable: isDraggable
  })));
};
exports.ThreatMatchRowView = ThreatMatchRowView;