"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showWith = exports.eventKindMatches = exports.WITH_FIELD_NAMES = exports.USER_NAME = exports.SOURCE_PORT = exports.SOURCE_IP = exports.PROCESS_PARENT_NAME = exports.PROCESS_NAME = exports.KIBANA_ALERT_SEVERITY = exports.KIBANA_ALERT_RULE_NAME = exports.ID = exports.HOST_NAME = exports.FILE_NAME = exports.EVENT_CATEGORY = exports.DESTINATION_PORT = exports.DESTINATION_IP = exports.DEFAULT_GAP = exports.AlertFieldFlexGroup = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _types = require("../../../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DESTINATION_IP = 'destination.ip';
exports.DESTINATION_IP = DESTINATION_IP;
const DESTINATION_PORT = 'destination.port';
exports.DESTINATION_PORT = DESTINATION_PORT;
const EVENT_CATEGORY = 'event.category';
exports.EVENT_CATEGORY = EVENT_CATEGORY;
const FILE_NAME = 'file.name';
exports.FILE_NAME = FILE_NAME;
const HOST_NAME = 'host.name';
exports.HOST_NAME = HOST_NAME;
const ID = '_id';
exports.ID = ID;
const KIBANA_ALERT_RULE_NAME = 'kibana.alert.rule.name';
exports.KIBANA_ALERT_RULE_NAME = KIBANA_ALERT_RULE_NAME;
const KIBANA_ALERT_SEVERITY = 'kibana.alert.severity';
exports.KIBANA_ALERT_SEVERITY = KIBANA_ALERT_SEVERITY;
const PROCESS_PARENT_NAME = 'process.parent.name';
exports.PROCESS_PARENT_NAME = PROCESS_PARENT_NAME;
const PROCESS_NAME = 'process.name';
exports.PROCESS_NAME = PROCESS_NAME;
const SOURCE_IP = 'source.ip';
exports.SOURCE_IP = SOURCE_IP;
const SOURCE_PORT = 'source.port';
exports.SOURCE_PORT = SOURCE_PORT;
const USER_NAME = 'user.name';
exports.USER_NAME = USER_NAME;
const eventKindMatches = eventKind => {
  var _eventKind$some;
  return (_eventKind$some = eventKind === null || eventKind === void 0 ? void 0 : eventKind.some(x => x.toLocaleLowerCase != null && x.toLowerCase() === 'signal')) !== null && _eventKind$some !== void 0 ? _eventKind$some : false;
};
exports.eventKindMatches = eventKindMatches;
const showWith = ({
  data,
  fieldNames
}) => fieldNames.some(x => (0, _fp.has)(x, data));

/** Show the word `with` if any of these fields are populated */
exports.showWith = showWith;
const WITH_FIELD_NAMES = [DESTINATION_IP, DESTINATION_PORT, FILE_NAME, PROCESS_NAME, PROCESS_PARENT_NAME, SOURCE_IP, SOURCE_PORT];
exports.WITH_FIELD_NAMES = WITH_FIELD_NAMES;
const DEFAULT_GAP = 3; // px
exports.DEFAULT_GAP = DEFAULT_GAP;
const AlertFieldFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex-grow: 0;
  gap: ${({
  $scopeId
}) => $scopeId === _types.TimelineId.active ? 0 : DEFAULT_GAP}px;
`;
exports.AlertFieldFlexGroup = AlertFieldFlexGroup;