"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonColumns = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var _note_previews = require("../note_previews");
var i18n = _interopRequireWildcard(require("../translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_date = require("../../../../common/components/formatted_date");
var _api = require("../../../../../common/types/timeline/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LineClampTextContainer = _styledComponents.default.span`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: 5;
  -webkit-box-orient: vertical;
  overflow: hidden;
`;

/**
 * Returns the column definitions (passed as the `columns` prop to
 * `EuiBasicTable`) that are common to the compact `Open Timeline` modal view,
 * and the full view shown in the `All Timelines` view of the `Timelines` page
 */
const getCommonColumns = ({
  itemIdToExpandedNotesRowMap,
  onOpenTimeline,
  onToggleShowNotes,
  timelineType
}) => [{
  isExpander: true,
  render: ({
    notes,
    savedObjectId
  }) => notes != null && notes.length > 0 && savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "expand-notes",
    onClick: () => itemIdToExpandedNotesRowMap[savedObjectId] != null ? onToggleShowNotes((0, _fp.omit)(savedObjectId, itemIdToExpandedNotesRowMap)) : onToggleShowNotes({
      ...itemIdToExpandedNotesRowMap,
      [savedObjectId]: /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
        notes: notes
      })
    }),
    "aria-label": itemIdToExpandedNotesRowMap[savedObjectId] ? i18n.COLLAPSE : i18n.EXPAND,
    iconType: itemIdToExpandedNotesRowMap[savedObjectId] ? 'arrowDown' : 'arrowRight'
  }) : null,
  width: _common_styles.ACTION_COLUMN_WIDTH
}, {
  dataType: 'string',
  field: 'title',
  name: timelineType === _api.TimelineType.default ? i18n.TIMELINE_NAME : i18n.TIMELINE_TEMPLATE_NAME,
  render: (title, timelineResult) => timelineResult.savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `title-${timelineResult.savedObjectId}`,
    onClick: () => onOpenTimeline({
      duplicate: false,
      timelineId: `${timelineResult.savedObjectId}`
    })
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : /*#__PURE__*/_react.default.createElement(LineClampTextContainer, null, title)) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `title-no-saved-object-id-${title || 'no-title'}`
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : title),
  sortable: false
}, {
  dataType: 'string',
  field: 'description',
  name: i18n.DESCRIPTION,
  render: description => /*#__PURE__*/_react.default.createElement(LineClampTextContainer, {
    "data-test-subj": "description"
  }, description != null && description.trim().length > 0 ? description : (0, _empty_value.getEmptyTagValue)()),
  sortable: false
}, {
  dataType: 'date',
  field: 'updated',
  name: i18n.LAST_MODIFIED,
  render: (date, timelineResult) => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "updated"
  }, timelineResult.updated != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: date
  }) : (0, _empty_value.getEmptyTagValue)()),
  sortable: true
}];
exports.getCommonColumns = getCommonColumns;