"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoteCards = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _add_note = require("../add_note");
var _note_previews = require("../../open_timeline/note_previews");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddNoteContainer = _styledComponents.default.div``;
AddNoteContainer.displayName = 'AddNoteContainer';
const NoteContainer = _styledComponents.default.div`
  margin-top: 5px;
`;
NoteContainer.displayName = 'NoteContainer';
const NoteCardsCompContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  border: none;
  background-color: transparent;
  box-shadow: none;

  &.euiPanel--plain {
    background-color: transparent;
  }
`;
NoteCardsCompContainer.displayName = 'NoteCardsCompContainer';
const NotesContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: 5px;
`;
NotesContainer.displayName = 'NotesContainer';
/** A view for entering and reviewing notes */
const NoteCards = /*#__PURE__*/_react.default.memo(({
  ariaRowindex,
  associateNote,
  notes,
  showAddNote,
  toggleShowAddNote
}) => {
  const [newNote, setNewNote] = (0, _react.useState)('');
  const associateNoteAndToggleShow = (0, _react.useCallback)(noteId => {
    associateNote(noteId);
    toggleShowAddNote();
  }, [associateNote, toggleShowAddNote]);
  return /*#__PURE__*/_react.default.createElement(NoteCardsCompContainer, {
    "data-test-subj": "note-cards",
    hasShadow: false,
    paddingSize: "none"
  }, notes.length ? /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviewsContainer, {
    "data-test-subj": "note-previews-container"
  }, /*#__PURE__*/_react.default.createElement(NotesContainer, {
    className: (0, _public.getNotesContainerClassName)(ariaRowindex),
    "data-test-subj": "notes",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "screenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.YOU_ARE_VIEWING_NOTES(ariaRowindex))), /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
    notes: notes
  }))) : null, showAddNote ? /*#__PURE__*/_react.default.createElement(AddNoteContainer, {
    "data-test-subj": "add-note-container"
  }, /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    associateNote: associateNoteAndToggleShow,
    newNote: newNote,
    onCancelAddNote: toggleShowAddNote,
    updateNewNote: setNewNote
  })) : null);
});
exports.NoteCards = NoteCards;
NoteCards.displayName = 'NoteCards';