"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ja3Fingerprint = exports.JA3_HASH_FIELD_NAME = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../common/components/draggables");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JA3_HASH_FIELD_NAME = 'tls.fingerprints.ja3.hash';
exports.JA3_HASH_FIELD_NAME = JA3_HASH_FIELD_NAME;
const Ja3FingerprintLabel = _styledComponents.default.span`
  margin-right: 5px;
`;
Ja3FingerprintLabel.displayName = 'Ja3FingerprintLabel';

/**
 * Renders a ja3 fingerprint, which enables (some) clients and servers communicating
 * using TLS traffic to be identified, which is possible because SSL
 * negotiations happen in the clear
 */
const Ja3Fingerprint = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  isDraggable,
  value
}) => /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "ja3-hash",
  eventId: eventId,
  field: fieldName,
  iconType: "snowflake",
  isDraggable: isDraggable,
  value: value,
  isAggregatable: true,
  fieldType: "keyword"
}, /*#__PURE__*/_react.default.createElement(Ja3FingerprintLabel, null, i18n.JA3_FINGERPRINT_LABEL), /*#__PURE__*/_react.default.createElement(_links.Ja3FingerprintLink, {
  "data-test-subj": "ja3-hash-link",
  ja3Fingerprint: value || ''
})));
exports.Ja3Fingerprint = Ja3Fingerprint;
Ja3Fingerprint.displayName = 'Ja3Fingerprint';