"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineKPIs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoWrapEuiStat = (0, _styledComponents.default)(_eui.EuiStat)`
  & .euiStat__description {
    white-space: nowrap;
  }
`;
const TimelineKPIs = /*#__PURE__*/_react.default.memo(({
  kpis,
  isLoading
}) => {
  const kpiFormat = '0,0.[000]a';
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const formattedKpis = (0, _react.useMemo)(() => {
    return {
      process: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.processCount).format(kpiFormat),
      user: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.userCount).format(kpiFormat),
      host: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.hostCount).format(kpiFormat),
      sourceIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.sourceIpCount).format(kpiFormat),
      destinationIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.destinationIpCount).format(kpiFormat)
    };
  }, [kpis]);
  const formattedKpiToolTips = (0, _react.useMemo)(() => {
    return {
      process: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.processCount).format(defaultNumberFormat),
      user: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.userCount).format(defaultNumberFormat),
      host: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.hostCount).format(defaultNumberFormat),
      sourceIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.sourceIpCount).format(defaultNumberFormat),
      destinationIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.destinationIpCount).format(defaultNumberFormat)
    };
  }, [kpis, defaultNumberFormat]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    "data-test-subj": "siem-timeline-kpis"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.process
  }, /*#__PURE__*/_react.default.createElement(NoWrapEuiStat, {
    "data-test-subj": "siem-timeline-process-kpi",
    title: formattedKpis.process,
    description: i18n.PROCESS_KPI_TITLE,
    titleSize: "s",
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.user
  }, /*#__PURE__*/_react.default.createElement(NoWrapEuiStat, {
    "data-test-subj": "siem-timeline-user-kpi",
    title: formattedKpis.user,
    description: i18n.USER_KPI_TITLE,
    titleSize: "s",
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.host
  }, /*#__PURE__*/_react.default.createElement(NoWrapEuiStat, {
    "data-test-subj": "siem-timeline-host-kpi",
    title: formattedKpis.host,
    description: i18n.HOST_KPI_TITLE,
    titleSize: "s",
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.sourceIp
  }, /*#__PURE__*/_react.default.createElement(NoWrapEuiStat, {
    "data-test-subj": "siem-timeline-source-ip-kpi",
    title: formattedKpis.sourceIp,
    description: i18n.SOURCE_IP_KPI_TITLE,
    titleSize: "s",
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.destinationIp
  }, /*#__PURE__*/_react.default.createElement(NoWrapEuiStat, {
    "data-test-subj": "siem-timeline-destination-ip-kpi",
    title: formattedKpis.destinationIp,
    description: i18n.DESTINATION_IP_KPI_TITLE,
    titleSize: "s",
    isLoading: isLoading
  }))));
});
exports.TimelineKPIs = TimelineKPIs;
TimelineKPIs.displayName = 'TimelineKPIs';