"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseButton = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _constants = require("../../../../../common/constants");
var _timeline = require("../../../store/timeline");
var _actions = require("../../../store/timeline/actions");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kibana = require("../../../../common/lib/kibana");
var _timeline2 = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _link_to = require("../../../../common/components/link_to");
var _types = require("../../../../app/types");
var _defaults = require("../../../store/timeline/defaults");
var i18n = _interopRequireWildcard(require("../../timeline/properties/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddToCaseButtonComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    cases,
    application: {
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    graphEventId,
    savedObjectId,
    status: timelineStatus,
    title: timelineTitle,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['graphEventId', 'savedObjectId', 'status', 'title', 'timelineType'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [isCaseModalOpen, openCaseModal] = (0, _react.useState)(false);
  const onRowClick = (0, _react.useCallback)(async theCase => {
    openCaseModal(false);
    await navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.case,
      path: theCase != null ? (0, _link_to.getCaseDetailsUrl)({
        id: theCase.id
      }) : (0, _link_to.getCreateCaseUrl)()
    });
    dispatch((0, _actions.setInsertTimeline)({
      graphEventId,
      timelineId,
      timelineSavedObjectId: savedObjectId,
      timelineTitle
    }));
  }, [dispatch, graphEventId, navigateToApp, savedObjectId, timelineId, timelineTitle]);
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const handleButtonClick = (0, _react.useCallback)(() => {
    setPopover(currentIsOpen => !currentIsOpen);
  }, []);
  const handlePopoverClose = (0, _react.useCallback)(() => setPopover(false), []);
  const handleNewCaseClick = (0, _react.useCallback)(() => {
    handlePopoverClose();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.case,
      path: (0, _link_to.getCreateCaseUrl)()
    }).then(() => {
      dispatch((0, _actions.setInsertTimeline)({
        graphEventId,
        timelineId,
        timelineSavedObjectId: savedObjectId,
        timelineTitle: timelineTitle.length > 0 ? timelineTitle : i18n.UNTITLED_TIMELINE
      }));
      dispatch((0, _actions.showTimeline)({
        id: _timeline2.TimelineId.active,
        show: false
      }));
    });
  }, [dispatch, graphEventId, navigateToApp, handlePopoverClose, savedObjectId, timelineId, timelineTitle]);
  const handleExistingCaseClick = (0, _react.useCallback)(() => {
    handlePopoverClose();
    openCaseModal(true);
  }, [openCaseModal, handlePopoverClose]);
  const onCaseModalClose = (0, _react.useCallback)(() => {
    openCaseModal(false);
  }, [openCaseModal]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "m",
    "data-test-subj": "attach-timeline-case-button",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: handleButtonClick,
    disabled: timelineStatus === _api.TimelineStatus.draft || timelineType !== _api.TimelineType.default
  }, i18n.ATTACH_TO_CASE), [handleButtonClick, timelineStatus, timelineType]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "new-case",
    "data-test-subj": "attach-timeline-new-case",
    onClick: handleNewCaseClick
  }, i18n.ATTACH_TO_NEW_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "existing-case",
    "data-test-subj": "attach-timeline-existing-case",
    onClick: handleExistingCaseClick
  }, i18n.ATTACH_TO_EXISTING_CASE)], [handleExistingCaseClick, handleNewCaseClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "singlePanel",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })), isCaseModalOpen && cases.ui.getAllCasesSelectorModal({
    onRowClick,
    onClose: onCaseModalClose,
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }));
};
AddToCaseButtonComponent.displayName = 'AddToCaseButtonComponent';
const AddToCaseButton = /*#__PURE__*/_react.default.memo(AddToCaseButtonComponent);
exports.AddToCaseButton = AddToCaseButton;