"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultValue = exports.ControlledDefaultInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../timeline/helpers");
var _helpers2 = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALUE_INPUT_CLASS_NAME = 'edit-data-provider-value';
const ControlledDefaultInput = ({
  value,
  onChangeCallback
}) => {
  const [primitiveValue, setPrimitiveValue] = (0, _react.useState)(getDefaultValue(value));
  (0, _react.useEffect)(() => {
    onChangeCallback((0, _helpers2.sanatizeValue)(primitiveValue));
  }, [primitiveValue, onChangeCallback]);
  const onValueChange = (0, _react.useCallback)(e => {
    setPrimitiveValue(e.target.value);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    className: VALUE_INPUT_CLASS_NAME,
    onChange: onValueChange,
    placeholder: i18n.VALUE,
    value: (0, _helpers2.sanatizeValue)(primitiveValue)
  });
};
exports.ControlledDefaultInput = ControlledDefaultInput;
const getDefaultValue = value => {
  if ((0, _helpers.isPrimitiveArray)(value)) {
    var _value$;
    return (_value$ = value[0]) !== null && _value$ !== void 0 ? _value$ : '';
  } else return value;
};
exports.getDefaultValue = getDefaultValue;