"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContentError = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _breadcrumbs = require("./breadcrumbs");
var _use_link_props = require("../use_link_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display an error in the panel when something goes wrong and give the user a way to "retreat" back to a default state.
 *
 * @param {function} pushToQueryparams A function to update the hash value in the URL to control panel state
 * @param {string} translatedErrorMessage The message to display in the panel when something goes wrong
 */
const PanelContentError = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  translatedErrorMessage
}) {
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodes'
  });
  const crumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.error.events', {
        defaultMessage: 'Events'
      }),
      ...nodesLinkNavProps
    }, {
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.error.error', {
        defaultMessage: 'Error'
      })
    }];
  }, [nodesLinkNavProps]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: crumbs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    "data-test-subj": "resolver:panel:error"
  }, translatedErrorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, nodesLinkNavProps, _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.error.goBack', {
    defaultMessage: 'View all processes'
  })));
});
exports.PanelContentError = PanelContentError;