"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _telemetry = require("./common/lib/telemetry");
var _services = require("./common/lib/kibana/services");
var _translations = require("./common/translations");
var _constants = require("../common/constants");
var _links = require("./common/links");
var _deep_links = require("./common/links/deep_links");
var _nav_links = require("./common/links/nav_links");
var _use_license = require("./common/hooks/use_license");
var _experimental_features_service = require("./common/experimental_features_service");
var _lazy_endpoint_policy_edit_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_edit_extension");
var _lazy_endpoint_policy_create_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_extension");
var _lazy_endpoint_policy_create_multi_step_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_create_multi_step_extension");
var _lazy_endpoint_package_custom_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_package_custom_extension");
var _lazy_endpoint_policy_response_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_policy_response_extension");
var _lazy_endpoint_generic_errors_list = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_generic_errors_list");
var _experimental_features = require("../common/experimental_features");
var _upsellings = require("./common/lib/upsellings");
var _lazy_endpoint_custom_assets_extension = require("./management/pages/policy/view/ingest_manager_integration/lazy_endpoint_custom_assets_extension");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Plugin {
  /**
   * The current Kibana branch. e.g. 'main'
   */

  /**
   * The current Kibana version. e.g. '8.0.0' or '8.0.0-SNAPSHOT'
   */

  /**
   * For internal use. Specify which version of the Detection Rules fleet package to install
   * when upgrading rules. If not provided, the latest compatible package will be installed,
   * or if running from a dev environment or -SNAPSHOT build, the latest pre-release package
   * will be used (if fleet is available or not within an airgapped environment).
   *
   * Note: This is for `upgrade only`, which occurs by means of the `useUpgradeSecurityPackages`
   * hook when navigating to a Security Solution page. The package version specified in
   * `fleet_packages.json` in project root will always be installed first on Kibana start if
   * the package is not already installed.
   */

  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "prebuiltRulesPackageVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "upsellingService", void 0);
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", void 0);
    (0, _defineProperty2.default)(this, "getStartedComponent$", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    (0, _defineProperty2.default)(this, "sessionStorage", new _public2.Storage(sessionStorage));
    /**
     * Lazily instantiated subPlugins.
     * See `subPlugins` method.
     */
    (0, _defineProperty2.default)(this, "_subPlugins", void 0);
    /**
     * Lazily instantiated `SecurityAppStore`.
     * See `store` method.
     */
    (0, _defineProperty2.default)(this, "_store", void 0);
    (0, _defineProperty2.default)(this, "_actionsRegistered", false);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []).features;
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.kibanaBranch = initializerContext.env.packageInfo.branch;
    this.prebuiltRulesPackageVersion = this.config.prebuiltRulesPackageVersion;
    this.isSidebarEnabled$ = new _rxjs.BehaviorSubject(true);
    this.getStartedComponent$ = new _rxjs.BehaviorSubject(null);
    this.upsellingService = new _upsellings.UpsellingService();
    this.telemetry = new _telemetry.TelemetryService();
  }
  setup(core, plugins) {
    (0, _telemetry.initTelemetry)({
      usageCollection: plugins.usageCollection
    }, _constants.APP_UI_ID);
    const telemetryContext = {
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    };
    this.telemetry.setup({
      analytics: core.analytics
    }, telemetryContext);
    if (plugins.home) {
      plugins.home.featureCatalogue.registerSolution({
        id: _constants.APP_ID,
        title: _translations.SOLUTION_NAME,
        description: _i18n.i18n.translate('xpack.securitySolution.featureCatalogueDescription', {
          defaultMessage: 'Prevent, collect, detect, and respond to threats for unified protection across your infrastructure.'
        }),
        icon: 'logoSecurity',
        path: _constants.APP_PATH,
        order: 300
      });
    }

    /**
     * `StartServices` which are needed by the `renderApp` function when mounting any of the subPlugin applications.
     * This is a promise because these aren't available until the `start` lifecycle phase but they are referenced
     * in the `setup` lifecycle phase.
     */
    const startServices = async params => {
      const [coreStart, startPluginsDeps] = await core.getStartServices();
      const {
        apm
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@elastic/apm-rum')));
      const {
        SecuritySolutionTemplateWrapper
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app/home/template_wrapper')));
      const {
        savedObjectsTaggingOss,
        ...startPlugins
      } = startPluginsDeps;
      const services = {
        ...coreStart,
        ...startPlugins,
        apm,
        savedObjectsTagging: savedObjectsTaggingOss.getTaggingApi(),
        storage: this.storage,
        sessionStorage: this.sessionStorage,
        security: startPluginsDeps.security,
        onAppLeave: params.onAppLeave,
        securityLayout: {
          getPluginWrapper: () => SecuritySolutionTemplateWrapper
        },
        savedObjectsManagement: startPluginsDeps.savedObjectsManagement,
        isSidebarEnabled$: this.isSidebarEnabled$,
        getStartedComponent$: this.getStartedComponent$,
        upselling: this.upsellingService,
        telemetry: this.telemetry.start()
      };
      return services;
    };
    core.application.register({
      id: _constants.APP_UI_ID,
      title: _translations.SOLUTION_NAME,
      appRoute: _constants.APP_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.security,
      // Initializing app as visible to make sure it appears on the Kibana home page, it is hidden when deepLinks update
      navLinkStatus: _public.AppNavLinkStatus.visible,
      searchable: true,
      updater$: this.appUpdater$,
      euiIconType: _constants.APP_ICON_SOLUTION,
      mount: async params => {
        // required to show the alert table inside cases
        const {
          alertsTableConfigurationRegistry
        } = plugins.triggersActionsUi;
        const {
          registerAlertsTableConfiguration
        } = await this.lazyRegisterAlertsTableConfiguration();
        registerAlertsTableConfiguration(alertsTableConfigurationRegistry, this.storage);
        const [coreStart, startPlugins] = await core.getStartServices();
        const subPlugins = await this.startSubPlugins(this.storage, coreStart, startPlugins);
        const store = await this.store(coreStart, startPlugins, subPlugins);
        const services = await startServices(params);
        await this.registerActions(store, params.history, services);
        const {
          renderApp
        } = await this.lazyApplicationDependencies();
        const {
          getSubPluginRoutesByCapabilities
        } = await this.lazyHelpersForRoutes();
        return renderApp({
          ...params,
          services,
          store,
          usageCollection: plugins.usageCollection,
          subPluginRoutes: getSubPluginRoutesByCapabilities(subPlugins, coreStart.application.capabilities, services)
        });
      }
    });
    core.application.register({
      id: 'siem',
      appRoute: 'app/siem',
      title: 'SIEM',
      navLinkStatus: 3,
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          manageOldSiemRoutes
        } = await this.lazyHelpersForRoutes();
        const subscription = this.appUpdater$.subscribe(() => {
          // wait for app initialization to set the links
          manageOldSiemRoutes(coreStart);
          subscription.unsubscribe();
        });
        return () => true;
      }
    });
    return {
      resolver: async () => {
        /**
         * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
         * See https://webpack.js.org/api/module-methods/#magic-comments
         */
        const {
          resolverPluginSetup
        } = await Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "resolver" */'./resolver')));
        return resolverPluginSetup();
      },
      upselling: this.upsellingService
    };
  }
  start(core, plugins) {
    _services.KibanaServices.init({
      ...core,
      ...plugins,
      kibanaBranch: this.kibanaBranch,
      kibanaVersion: this.kibanaVersion,
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    });
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    _use_license.licenseService.start(plugins.licensing.license$);
    if (plugins.fleet) {
      const {
        registerExtension
      } = plugins.fleet;
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-edit',
        Component: (0, _lazy_endpoint_policy_edit_extension.getLazyEndpointPolicyEditExtension)(core, plugins)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-response',
        Component: (0, _lazy_endpoint_policy_response_extension.getLazyEndpointPolicyResponseExtension)(core, plugins)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-generic-errors-list',
        Component: (0, _lazy_endpoint_generic_errors_list.getLazyEndpointGenericErrorsListExtension)(core, plugins)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create',
        Component: _lazy_endpoint_policy_create_extension.LazyEndpointPolicyCreateExtension
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-policy-create-multi-step',
        Component: _lazy_endpoint_policy_create_multi_step_extension.LazyEndpointPolicyCreateMultiStepExtension
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-custom',
        Component: (0, _lazy_endpoint_package_custom_extension.getLazyEndpointPackageCustomExtension)(core, plugins)
      });
      registerExtension({
        package: 'endpoint',
        view: 'package-detail-assets',
        Component: _lazy_endpoint_custom_assets_extension.LazyEndpointCustomAssetsExtension
      });
    }

    // Not using await to prevent blocking start execution
    this.registerAppLinks(core, plugins);
    return {
      getNavLinks$: () => _nav_links.navLinks$,
      setIsSidebarEnabled: isSidebarEnabled => this.isSidebarEnabled$.next(isSidebarEnabled),
      setGetStartedPage: getStartedComponent => {
        this.getStartedComponent$.next(getStartedComponent);
      }
    };
  }
  stop() {
    _use_license.licenseService.stop();
    return {};
  }
  lazyHelpersForRoutes() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyHelpersForRoutes" */
    './helpers')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazyApplicationDependencies() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_application_dependencies" */
    './lazy_application_dependencies')));
  }

  /**
   * The dependencies needed to mount the applications. These are dynamically loaded for the sake of webpack bundling efficiency.
   * Webpack is smart enough to only request (and download) this even when it is imported multiple times concurrently.
   */
  lazySubPlugins() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_sub_plugins" */
    './lazy_sub_plugins')));
  }
  lazyRegisterAlertsTableConfiguration() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_register_alerts_table_configuration" */
    './common/lib/triggers_actions_ui/register_alerts_table_configuration')));
  }
  lazyApplicationLinks() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_app_links" */
    './common/links/app_links')));
  }
  lazyActions() {
    /**
     * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
     * See https://webpack.js.org/api/module-methods/#magic-comments
     */
    return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "actions" */
    './actions')));
  }

  /**
   * Lazily instantiated subPlugins. This should be instantiated just once.
   */
  async subPlugins() {
    if (!this._subPlugins) {
      const {
        subPluginClasses
      } = await this.lazySubPlugins();
      this._subPlugins = {
        alerts: new subPluginClasses.Detections(),
        rules: new subPluginClasses.Rules(),
        exceptions: new subPluginClasses.Exceptions(),
        cases: new subPluginClasses.Cases(),
        dashboards: new subPluginClasses.Dashboards(),
        explore: new subPluginClasses.Explore(),
        kubernetes: new subPluginClasses.Kubernetes(),
        overview: new subPluginClasses.Overview(),
        timelines: new subPluginClasses.Timelines(),
        management: new subPluginClasses.Management(),
        cloudDefend: new subPluginClasses.CloudDefend(),
        cloudSecurityPosture: new subPluginClasses.CloudSecurityPosture(),
        threatIntelligence: new subPluginClasses.ThreatIntelligence()
      };
    }
    return this._subPlugins;
  }

  /**
   * All started subPlugins.
   */
  async startSubPlugins(storage, core, plugins) {
    const subPlugins = await this.subPlugins();
    return {
      alerts: subPlugins.alerts.start(storage),
      cases: subPlugins.cases.start(),
      cloudDefend: subPlugins.cloudDefend.start(),
      cloudSecurityPosture: subPlugins.cloudSecurityPosture.start(),
      dashboards: subPlugins.dashboards.start(),
      exceptions: subPlugins.exceptions.start(storage),
      explore: subPlugins.explore.start(storage),
      kubernetes: subPlugins.kubernetes.start(),
      management: subPlugins.management.start(core, plugins),
      overview: subPlugins.overview.start(),
      rules: subPlugins.rules.start(storage),
      threatIntelligence: subPlugins.threatIntelligence.start(),
      timelines: subPlugins.timelines.start()
    };
  }
  /**
   * Lazily instantiate a `SecurityAppStore`. We lazily instantiate this because it requests large dynamic imports. We instantiate it once because each subPlugin needs to share the same reference.
   */
  async store(coreStart, startPlugins, subPlugins) {
    if (!this._store) {
      const {
        createStoreFactory
      } = await this.lazyApplicationDependencies();
      this._store = await createStoreFactory(coreStart, startPlugins, subPlugins, this.storage, this.experimentalFeatures);
    }
    if (startPlugins.timelines) {
      startPlugins.timelines.setTimelineEmbeddedStore(this._store);
    }
    return this._store;
  }
  async registerActions(store, history, services) {
    if (!this._actionsRegistered) {
      const {
        registerActions
      } = await this.lazyActions();
      registerActions(store, history, services);
      this._actionsRegistered = true;
    }
  }

  /**
   * Register deepLinks and appUpdater for all app links, to change deepLinks as needed when licensing changes.
   */
  async registerAppLinks(core, plugins) {
    const {
      links,
      getFilteredLinks
    } = await this.lazyApplicationLinks();
    const {
      license$
    } = plugins.licensing;
    (0, _deep_links.registerDeepLinksUpdater)(this.appUpdater$);
    license$.subscribe(async license => {
      const linksPermissions = {
        experimentalFeatures: this.experimentalFeatures,
        upselling: this.upsellingService,
        capabilities: core.application.capabilities
      };
      if (license.type !== undefined) {
        linksPermissions.license = license;
      }

      // set initial links to not block rendering
      (0, _links.updateAppLinks)(links, linksPermissions);

      // set filtered links asynchronously
      const filteredLinks = await getFilteredLinks(core, plugins);
      (0, _links.updateAppLinks)(filteredLinks, linksPermissions);
    });
  }
}
exports.Plugin = Plugin;