"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulOverview = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _search_bar = require("../../common/components/search_bar");
var _page_wrapper = require("../../common/components/page_wrapper");
var _use_global_time = require("../../common/containers/use_global_time");
var _source = require("../../common/containers/source");
var _events_by_dataset = require("../components/events_by_dataset");
var _event_counts = require("../components/event_counts");
var _sidebar = require("../components/sidebar");
var _signals_by_category = require("../components/signals_by_category");
var _store = require("../../common/store");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _endpoint_notice = require("../components/endpoint_notice");
var _use_messages_storage = require("../../common/containers/local_storage/use_messages_storage");
var _constants2 = require("../../../common/constants");
var _sourcerer = require("../../common/containers/sourcerer");
var _use_selector = require("../../common/hooks/use_selector");
var _overview_cti_links = require("../components/overview_cti_links");
var _use_all_ti_data_sources = require("../containers/overview_cti_links/use_all_ti_data_sources");
var _user_privileges = require("../../common/components/user_privileges");
var _use_alerts_privileges = require("../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _landing_page = require("../../common/components/landing_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewComponent = () => {
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    from,
    deleteQuery,
    setQuery,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    indicesExist,
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)();
  const endpointMetadataIndex = (0, _react.useMemo)(() => {
    return [_constants2.ENDPOINT_METADATA_INDEX];
  }, []);
  const [, {
    indexExists: metadataIndexExists
  }] = (0, _source.useFetchIndex)(endpointMetadataIndex, true);
  const {
    addMessage,
    hasMessage
  } = (0, _use_messages_storage.useMessagesStorage)();
  const hasDismissEndpointNoticeMessage = (0, _react.useMemo)(() => hasMessage('management', 'dismissEndpointNotice'), [hasMessage]);
  const [dismissMessage, setDismissMessage] = (0, _react.useState)(hasDismissEndpointNoticeMessage);
  const dismissEndpointNotice = (0, _react.useCallback)(() => {
    setDismissMessage(true);
    addMessage('management', 'dismissEndpointNotice');
  }, [addMessage]);
  const {
    endpointPrivileges: {
      canAccessFleet
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    hasIndexRead,
    hasKibanaREAD
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const {
    tiDataSources: allTiDataSources,
    isInitiallyLoaded: isTiLoaded
  } = (0, _use_all_ti_data_sources.useAllTiDataSources)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, !dismissMessage && !metadataIndexExists && canAccessFleet && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_endpoint_notice.EndpointNotice, {
    onDismiss: dismissEndpointNotice
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['xl']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_sidebar.StatefulSidebar, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none"
  }, hasIndexRead && hasKibanaREAD && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_signals_by_category.SignalsByCategory, {
    filters: filters,
    query: query
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_events_by_dataset.EventsByDataset, {
    deleteQuery: deleteQuery,
    filters: filters,
    from: from,
    indexPattern: indexPattern,
    indexNames: selectedPatterns,
    query: query,
    queryType: "overview",
    setQuery: setQuery,
    to: to
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_event_counts.EventCounts, {
    filters: filters,
    from: from,
    indexNames: selectedPatterns,
    indexPattern: indexPattern,
    query: query,
    setQuery: setQuery,
    to: to
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, isTiLoaded && /*#__PURE__*/_react.default.createElement(_overview_cti_links.ThreatIntelLinkPanel, {
    allTiDataSources: allTiDataSources,
    deleteQuery: deleteQuery,
    from: from,
    setQuery: setQuery,
    to: to
  }))))))))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.overview
  }));
};
const StatefulOverview = /*#__PURE__*/_react.default.memo(OverviewComponent);
exports.StatefulOverview = StatefulOverview;