"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointOverview = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _endpoint_agent_status = require("../../../../common/components/endpoint/endpoint_agent_status");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _empty_value = require("../../../../common/components/empty_value");
var _field_renderers = require("../../../../timelines/components/field_renderers/field_renderers");
var i18n = _interopRequireWildcard(require("./translations"));
var _hosts = require("../../../../../common/search_strategy/security_solution/hosts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointOverview = /*#__PURE__*/_react.default.memo(({
  contextID,
  data
}) => {
  const getDefaultRenderer = (0, _react.useCallback)((fieldName, fieldData, attrName) => /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
    rowItems: [(0, _fp.getOr)('', fieldName, fieldData)],
    attrName: attrName,
    idPrefix: contextID ? `endpoint-overview-${contextID}` : 'endpoint-overview'
  }), [contextID]);
  const descriptionLists = (0, _react.useMemo)(() => {
    var _data$hostInfo, _appliedPolicy$name, _data$hostInfo2;
    const appliedPolicy = data === null || data === void 0 ? void 0 : (_data$hostInfo = data.hostInfo) === null || _data$hostInfo === void 0 ? void 0 : _data$hostInfo.metadata.Endpoint.policy.applied;
    return [[{
      title: i18n.ENDPOINT_POLICY,
      description: (_appliedPolicy$name = appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.name) !== null && _appliedPolicy$name !== void 0 ? _appliedPolicy$name : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.POLICY_STATUS,
      description: appliedPolicy !== null && appliedPolicy !== void 0 && appliedPolicy.status ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        "aria-label": appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status,
        color: (appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) === _hosts.HostPolicyResponseActionStatus.failure ? 'danger' : appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status
      }, appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.SENSORVERSION,
      description: data !== null && data !== void 0 && (_data$hostInfo2 = data.hostInfo) !== null && _data$hostInfo2 !== void 0 && _data$hostInfo2.metadata.agent.version ? getDefaultRenderer('hostInfo.metadata.agent.version', data, 'agent.version') : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.FLEET_AGENT_STATUS,
      description: data != null && data.hostInfo ? /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatus, {
        endpointHostInfo: data.hostInfo,
        "data-test-subj": "endpointHostAgentStatus"
      }) : (0, _empty_value.getEmptyTagValue)()
    }]];
  }, [data, getDefaultRenderer]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: "endpoint-overview",
    descriptionList: descriptionList,
    key: index
  })));
});
exports.EndpointOverview = EndpointOverview;
EndpointOverview.displayName = 'EndpointOverview';