"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreHeaderContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _severity_filter_group = require("../../../../explore/components/risk_score/severity/severity_filter_group");
var _search_strategy = require("../../../../../common/search_strategy");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreHeaderContentComponent = ({
  entityDocLink,
  entityLinkProps,
  onSelectSeverityFilterGroup,
  riskEntity,
  selectedSeverity,
  severityCount,
  toggleStatus
}) => {
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const [goToEntityRiskTab, entityRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps(entityLinkProps);
    return [onClick, href];
  }, [entityLinkProps, getSecuritySolutionLinkProps]);
  return toggleStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    "data-test-subj": `${riskEntity}-risk-score-header-content`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    rel: "noopener nofollow noreferrer",
    href: entityDocLink,
    target: "_blank"
  }, i18n.LEARN_MORE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_severity_filter_group.SeverityFilterGroup, {
    selectedSeverities: selectedSeverity,
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    riskEntity: riskEntity,
    onSelect: onSelectSeverityFilterGroup
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "data-test-subj": "view-all-button",
    onClick: goToEntityRiskTab,
    href: entityRiskTabUrl
  }, i18n.VIEW_ALL))) : null;
};
const RiskScoreHeaderContent = /*#__PURE__*/_react.default.memo(RiskScoreHeaderContentComponent);
exports.RiskScoreHeaderContent = RiskScoreHeaderContent;