"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../common/constants");
var _types = require("../app/types");
var _pages = require("./pages");
var _current_license = require("../common/components/current_license");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _landing = require("./pages/landing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagementLanding = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _types.SecurityPageName.administration
}, /*#__PURE__*/_react.default.createElement(_landing.ManageLandingPage, null)));

/**
 * Returns the React Router Routes for the management area
 */
const ManagementRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_current_license.CurrentLicense, null, /*#__PURE__*/_react.default.createElement(_pages.ManagementContainer, null)));
const routes = [{
  path: _constants.MANAGE_PATH,
  component: /*#__PURE__*/_react.default.memo(ManagementLanding)
}, {
  path: _constants.MANAGEMENT_PATH,
  component: /*#__PURE__*/_react.default.memo(ManagementRoutes)
}];
exports.routes = routes;