"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWindowsTrustedAppCondition = exports.isMacosLinuxTrustedAppCondition = void 0;
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isWindowsTrustedAppCondition = condition => {
  return condition.field === _securitysolutionUtils.ConditionEntryField.SIGNER || true;
};
exports.isWindowsTrustedAppCondition = isWindowsTrustedAppCondition;
const isMacosLinuxTrustedAppCondition = condition => {
  return condition.field !== _securitysolutionUtils.ConditionEntryField.SIGNER;
};
exports.isMacosLinuxTrustedAppCondition = isMacosLinuxTrustedAppCondition;