"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/fleet-plugin/public");
var _user_privileges = require("../../../../common/components/user_privileges");
var _administration_list_page = require("../../../components/administration_list_page");
var _formatted_date = require("../../../../common/components/formatted_date");
var _endpoint_policy_link = require("../../../components/endpoint_policy_link");
var _use_url_pagination = require("../../../hooks/use_url_pagination");
var _hooks = require("../../../services/policies/hooks");
var _management_empty_state = require("../../../components/management_empty_state");
var _use_navigate_to_app_event_handler = require("../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _constants = require("../../../../../common/constants");
var _routing = require("../../../common/routing");
var _kibana = require("../../../../common/lib/kibana");
var _policy_endpoint_count = require("./components/policy_endpoint_count");
var _management_empty_state_wrapper = require("../../../components/management_empty_state_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canReadEndpointList,
    loading: authLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _use_url_pagination.useUrlPagination)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const toasts = (0, _kibana.useToasts)();

  // load the list of policies
  const {
    data,
    isFetching: policyIsFetching,
    error
  } = (0, _hooks.useGetEndpointSpecificPolicies)({
    page: pagination.page,
    perPage: pagination.pageSize
  });

  // grab endpoint version for empty page
  const {
    data: endpointPackageInfo,
    isFetching: packageIsFetching
  } = (0, _hooks.useGetEndpointSecurityPackage)({
    customQueryOptions: {
      onError: err => {
        toasts.addDanger(_i18n.i18n.translate('xpack.securitySolution.policyList.packageVersionError', {
          defaultMessage: 'Error retrieving the endpoint package version'
        }));
      }
    }
  });
  const totalItemCount = (0, _react.useMemo)(() => {
    var _data$total;
    return (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  }, [data]);
  const policyListPath = (0, _react.useMemo)(() => (0, _routing.getPoliciesPath)(search), [search]);
  const backLink = (0, _react.useMemo)(() => {
    return {
      navigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }],
      label: _i18n.i18n.translate('xpack.securitySolution.policy.backToPolicyList', {
        defaultMessage: 'Back to policy list'
      }),
      href: getAppUrl({
        path: policyListPath
      })
    };
  }, [getAppUrl, policyListPath]);
  const handleCreatePolicyClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)('fleet', {
    path: _public.pagePathGetters.add_integration_to_policy({
      pkgkey: endpointPackageInfo ? `/endpoint-${endpointPackageInfo === null || endpointPackageInfo === void 0 ? void 0 : endpointPackageInfo.version}` : ''
    })[1],
    state: {
      onCancelNavigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }],
      onCancelUrl: getAppUrl({
        path: (0, _routing.getPoliciesPath)()
      }),
      onSaveNavigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }]
    }
  });
  const policyColumns = (0, _react.useMemo)(() => {
    const updatedAtColumnName = _i18n.i18n.translate('xpack.securitySolution.policy.list.updatedAt', {
      defaultMessage: 'Last Updated'
    });
    const createdAtColumnName = _i18n.i18n.translate('xpack.securitySolution.policy.list.createdAt', {
      defaultMessage: 'Date Created'
    });
    return [{
      field: '',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.name', {
        defaultMessage: 'Name'
      }),
      truncateText: true,
      render: policy => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: policy.name,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_link.EndpointPolicyLink, {
          policyId: policy.id,
          className: "eui-textTruncate",
          "data-test-subj": "policyNameCellLink",
          backLink: backLink
        }, policy.name));
      }
    }, {
      field: 'created_by',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.createdBy', {
        defaultMessage: 'Created by'
      }),
      truncateText: true,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          gutterSize: 'xs',
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
          name: name,
          "data-test-subj": 'created-by-avatar',
          size: "s"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "created-by-name"
        }, name)));
      }
    }, {
      field: 'created_at',
      name: createdAtColumnName,
      truncateText: true,
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          fieldName: createdAtColumnName,
          value: date,
          className: "eui-textTruncate"
        });
      }
    }, {
      field: 'updated_by',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.lastUpdatedBy', {
        defaultMessage: 'Last updated by'
      }),
      truncateText: true,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          gutterSize: 'xs',
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
          name: name,
          "data-test-subj": 'updated-by-avatar',
          size: "s"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "updated-by-name"
        }, name)));
      }
    }, {
      field: 'updated_at',
      name: updatedAtColumnName,
      truncateText: true,
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          fieldName: updatedAtColumnName,
          value: date,
          className: "eui-textTruncate"
        });
      }
    }, {
      field: '',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.endpoints', {
        defaultMessage: 'Endpoints'
      }),
      width: '8%',
      render: policy => {
        var _policy$agents;
        const count = (_policy$agents = policy.agents) !== null && _policy$agents !== void 0 ? _policy$agents : 0;
        return /*#__PURE__*/_react.default.createElement(_policy_endpoint_count.PolicyEndpointCount, {
          className: "eui-textTruncate",
          "data-test-subj": "policyEndpointCountLink",
          policyId: policy.id,
          nonLinkCondition: authLoading || !canReadEndpointList || count === 0
        }, count);
      }
    }];
  }, [backLink, authLoading, canReadEndpointList]);
  const handleTableOnChange = (0, _react.useCallback)(({
    page
  }) => {
    setPagination({
      page: page.index + 1,
      pageSize: page.size
    });
  }, [setPagination]);
  const tablePagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.pageSize,
      totalItemCount,
      pageSizeOptions
    };
  }, [totalItemCount, pageSizeOptions, pagination.page, pagination.pageSize]);
  const policyListErrorMessage = _i18n.i18n.translate('xpack.securitySolution.policy.list.errorMessage', {
    defaultMessage: 'Error while retrieving list of policies'
  });
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "policyListPage",
    hideHeader: totalItemCount === 0,
    title: _i18n.i18n.translate('xpack.securitySolution.policy.list.title', {
      defaultMessage: 'Policies'
    }),
    subtitle: _i18n.i18n.translate('xpack.securitySolution.policy.list.subtitle', {
      defaultMessage: 'Use policies to customize endpoint and cloud workload protections and other configurations'
    })
  }, totalItemCount > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "endpointListTableTotal"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policy.list.totalCount",
    defaultMessage: "Showing {totalItemCount, plural, one {# policy} other {# policies}}",
    values: {
      totalItemCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "policyListTable",
    items: (data === null || data === void 0 ? void 0 : data.items) || [],
    columns: policyColumns,
    pagination: tablePagination,
    onChange: handleTableOnChange,
    loading: policyIsFetching,
    error: error !== null ? policyListErrorMessage : ''
  })) : /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, null, /*#__PURE__*/_react.default.createElement(_management_empty_state.PolicyEmptyState, {
    loading: packageIsFetching,
    onActionClick: handleCreatePolicyClick,
    policyEntryPoint: true
  })));
});
exports.PolicyList = PolicyList;
PolicyList.displayName = 'PolicyList';