"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinuxEvents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _selectors = require("../../../store/policy_details/selectors");
var _policy_details_config = require("../../../models/policy_details_config");
var _policy_hooks = require("../../policy_hooks");
var _events_form = require("../../components/events_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPTIONS = [{
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.file', {
    defaultMessage: 'File'
  }),
  protectionField: 'file'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.network', {
    defaultMessage: 'Network'
  }),
  protectionField: 'network'
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.process', {
    defaultMessage: 'Process'
  }),
  protectionField: 'process'
}];
const SUPPLEMENTAL_OPTIONS = [{
  title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.title', {
    defaultMessage: 'Session data'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data.description', {
    defaultMessage: 'Turn this on to capture the extended process data required for Session View. Session View provides you a visual representation of session and process execution data. Session View data is organized according to the Linux process model to help you investigate process, user, and service activity on your Linux infrastructure.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.session_data', {
    defaultMessage: 'Collect session data'
  }),
  protectionField: 'session_data',
  isDisabled: config => {
    return !config.linux.events.process;
  }
}, {
  name: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_io', {
    defaultMessage: 'Capture terminal output'
  }),
  protectionField: 'tty_io',
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.linux.events.tty_io.tooltip', {
    defaultMessage: 'Turn this on to collect terminal (tty) output. Terminal output appears in Session View, and you can view it separately to see what commands were executed and how they were typed, provided the terminal is in echo mode. Only works on hosts that support ebpf.'
  }),
  indented: true,
  isDisabled: config => {
    return !config.linux.events.session_data;
  },
  beta: true
}];
const LinuxEvents = /*#__PURE__*/(0, _react.memo)(() => {
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_events_form.EventsForm, {
    os: _securitysolutionUtils.OperatingSystem.LINUX,
    selection: policyDetailsConfig.linux.events,
    options: OPTIONS,
    supplementalOptions: SUPPLEMENTAL_OPTIONS,
    onValueSelection: (value, selected) => {
      let newConfig = (0, _policy_details_config.setIn)(policyDetailsConfig)('linux')('events')(value)(selected);
      if (value === 'session_data' && !selected) {
        newConfig = (0, _policy_details_config.setIn)(newConfig)('linux')('events')('tty_io')(false);
      }
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newConfig
        }
      });
    }
  });
});
exports.LinuxEvents = LinuxEvents;
LinuxEvents.displayName = 'LinuxEvents';