"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetailsForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _user_privileges = require("../../../../common/components/user_privileges");
var _malware = require("./policy_forms/protections/malware");
var _memory = require("./policy_forms/protections/memory");
var _behavior = require("./policy_forms/protections/behavior");
var _events = require("./policy_forms/events");
var _policy_advanced = require("./policy_advanced");
var _antivirus_registration_form = require("./components/antivirus_registration_form");
var _attack_surface_reduction_form = require("./components/attack_surface_reduction_form");
var _ransomware = require("./policy_forms/protections/ransomware");
var _locked_card = require("./policy_forms/locked_card");
var _use_license = require("../../../../common/hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCKED_CARD_RAMSOMWARE_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.ransomware', {
  defaultMessage: 'Ransomware'
});
const LOCKED_CARD_MEMORY_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.memory', {
  defaultMessage: 'Memory Threat'
});
const LOCKED_CARD_BEHAVIOR_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.behavior', {
  defaultMessage: 'Malicious Behavior'
});
const LOCKED_CARD_ATTACK_SURFACE_REDUCTION = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.attack_surface_reduction', {
  defaultMessage: 'Attack Surface Reduction'
});
const PolicyDetailsForm = /*#__PURE__*/(0, _react.memo)(() => {
  const [showAdvancedPolicy, setShowAdvancedPolicy] = (0, _react.useState)(false);
  const handleAdvancedPolicyClick = (0, _react.useCallback)(() => {
    setShowAdvancedPolicy(!showAdvancedPolicy);
  }, [showAdvancedPolicy]);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const {
    loading: authzLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  if (authzLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 5
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.protections",
    defaultMessage: "Protections"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_malware.MalwareProtections, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_ransomware.Ransomware, null) : /*#__PURE__*/_react.default.createElement(_locked_card.LockedPolicyCard, {
    title: LOCKED_CARD_RAMSOMWARE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_memory.MemoryProtection, null) : /*#__PURE__*/_react.default.createElement(_locked_card.LockedPolicyCard, {
    title: LOCKED_CARD_MEMORY_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_behavior.BehaviorProtection, null) : /*#__PURE__*/_react.default.createElement(_locked_card.LockedPolicyCard, {
    title: LOCKED_CARD_BEHAVIOR_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_attack_surface_reduction_form.AttackSurfaceReductionForm, null) : /*#__PURE__*/_react.default.createElement(_locked_card.LockedPolicyCard, {
    title: LOCKED_CARD_ATTACK_SURFACE_REDUCTION
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.settings",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_events.WindowsEvents, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_events.MacEvents, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_events.LinuxEvents, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_antivirus_registration_form.AntivirusRegistrationForm, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "advancedPolicyButton",
    onClick: handleAdvancedPolicyClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.advanced.show",
    defaultMessage: "{action} advanced settings",
    values: {
      action: showAdvancedPolicy ? 'Hide' : 'Show'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), showAdvancedPolicy && /*#__PURE__*/_react.default.createElement(_policy_advanced.AdvancedPolicyForms, {
    isPlatinumPlus: isPlatinumPlus
  }));
});
exports.PolicyDetailsForm = PolicyDetailsForm;
PolicyDetailsForm.displayName = 'PolicyDetailsForm';