"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedPolicyForms = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _selectors = require("../store/policy_details/selectors");
var _policy_hooks = require("./policy_hooks");
var _advanced_policy_schema = require("../models/advanced_policy_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setValue(obj, value, path) {
  let newPolicyConfig = obj;

  // First set the value.
  for (let i = 0; i < path.length - 1; i++) {
    if (!newPolicyConfig[path[i]]) {
      newPolicyConfig[path[i]] = {};
    }
    newPolicyConfig = newPolicyConfig[path[i]];
  }
  newPolicyConfig[path[path.length - 1]] = value;

  // Then, if the user is deleting the value, we need to ensure we clean up the config.
  // We delete any sections that are empty, whether that be an empty string, empty object, or undefined.
  if (value === '' || value === undefined) {
    newPolicyConfig = obj;
    for (let k = path.length; k >= 0; k--) {
      const nextPath = path.slice(0, k);
      for (let i = 0; i < nextPath.length - 1; i++) {
        // Traverse and find the next section
        newPolicyConfig = newPolicyConfig[nextPath[i]];
      }
      if (newPolicyConfig[nextPath[nextPath.length - 1]] === undefined || newPolicyConfig[nextPath[nextPath.length - 1]] === '' || Object.keys(newPolicyConfig[nextPath[nextPath.length - 1]]).length === 0) {
        // If we're looking at the `advanced` field, we leave it undefined as opposed to deleting it.
        // This is because the UI looks for this field to begin rendering.
        if (nextPath[nextPath.length - 1] === 'advanced') {
          newPolicyConfig[nextPath[nextPath.length - 1]] = undefined;
          // In all other cases, if field is empty, we'll delete it to clean up.
        } else {
          delete newPolicyConfig[nextPath[nextPath.length - 1]];
        }
        newPolicyConfig = obj;
      } else {
        break; // We are looking at a non-empty section, so we can terminate.
      }
    }
  }
}

function getValue(obj, path) {
  let currentPolicyConfig = obj;
  for (let i = 0; i < path.length - 1; i++) {
    if (currentPolicyConfig[path[i]]) {
      currentPolicyConfig = currentPolicyConfig[path[i]];
    } else {
      return undefined;
    }
  }
  return currentPolicyConfig[path[path.length - 1]];
}
const calloutTitle = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.calloutTitle', {
  defaultMessage: 'Proceed with caution!'
});
const warningMessage = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.advanced.warningMessage', {
  defaultMessage: `This section contains policy values that support advanced use cases. If not configured
    properly, these values can cause unpredictable behavior. Please consult documentation
    carefully or contact support before editing these values.`
});
const AdvancedPolicyForms = /*#__PURE__*/_react.default.memo(({
  isPlatinumPlus
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutTitle,
    color: "warning",
    iconType: "warning",
    "data-test-subj": "policyAdvancedSettingsWarning"
  }, /*#__PURE__*/_react.default.createElement("p", null, warningMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.advanced",
    defaultMessage: "Advanced settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "advancedPolicyPanel",
    paddingSize: "s"
  }, _advanced_policy_schema.AdvancedPolicySchema.map((advancedField, index) => {
    const configPath = advancedField.key.split('.');
    const failsPlatinumLicenseCheck = !isPlatinumPlus && advancedField.license === 'platinum';
    return !failsPlatinumLicenseCheck && /*#__PURE__*/_react.default.createElement(PolicyAdvanced, {
      key: index,
      configPath: configPath,
      firstSupportedVersion: advancedField.first_supported_version,
      lastSupportedVersion: advancedField.last_supported_version,
      documentation: advancedField.documentation
    });
  })));
});
exports.AdvancedPolicyForms = AdvancedPolicyForms;
AdvancedPolicyForms.displayName = 'AdvancedPolicyForms';
const PolicyAdvanced = /*#__PURE__*/_react.default.memo(({
  configPath,
  firstSupportedVersion,
  lastSupportedVersion,
  documentation
}) => {
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const onChange = (0, _react.useCallback)(event => {
    if (policyDetailsConfig) {
      const newPayload = (0, _lodash.cloneDeep)(policyDetailsConfig);
      setValue(newPayload, event.target.value, configPath);
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newPayload
        }
      });
    }
  }, [dispatch, policyDetailsConfig, configPath]);
  const value = policyDetailsConfig && getValue(policyDetailsConfig, configPath);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, configPath.join('.')), documentation && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: documentation,
      position: "right"
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, lastSupportedVersion ? `${firstSupportedVersion}-${lastSupportedVersion}` : `${firstSupportedVersion}+`)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": configPath.join('.'),
    fullWidth: true,
    value: value,
    onChange: onChange,
    disabled: !showEditableFormFields
  })));
});
PolicyAdvanced.displayName = 'PolicyAdvanced';